/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sequencedmultisetstate.linked;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedHashFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.HashFunction;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.RowDataKey;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.RowDataKeySerializerSnapshot;
import org.apache.flink.util.Preconditions;

@Internal
public class RowDataKeySerializer
extends TypeSerializer<RowDataKey> {
    final TypeSerializer<RowData> serializer;
    final GeneratedRecordEqualiser equaliser;
    final GeneratedHashFunction hashFunction;
    final RecordEqualiser equalizerInstance;
    final HashFunction hashFunctionInstance;

    public RowDataKeySerializer(TypeSerializer<RowData> serializer, RecordEqualiser equalizerInstance, HashFunction hashFunctionInstance, GeneratedRecordEqualiser equaliser, GeneratedHashFunction hashFunction) {
        this.serializer = (TypeSerializer)Preconditions.checkNotNull(serializer);
        this.equalizerInstance = (RecordEqualiser)Preconditions.checkNotNull((Object)equalizerInstance);
        this.hashFunctionInstance = (HashFunction)Preconditions.checkNotNull((Object)hashFunctionInstance);
        this.equaliser = (GeneratedRecordEqualiser)Preconditions.checkNotNull((Object)equaliser);
        this.hashFunction = (GeneratedHashFunction)Preconditions.checkNotNull((Object)hashFunction);
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<RowDataKey> duplicate() {
        return new RowDataKeySerializer((TypeSerializer<RowData>)this.serializer.duplicate(), this.equalizerInstance, this.hashFunctionInstance, this.equaliser, this.hashFunction);
    }

    public RowDataKey createInstance() {
        return new RowDataKey(this.equalizerInstance, this.hashFunctionInstance);
    }

    public RowDataKey copy(RowDataKey from) {
        return RowDataKey.toKeyNotProjected((RowData)this.serializer.copy((Object)from.rowData), this.equalizerInstance, this.hashFunctionInstance);
    }

    public RowDataKey copy(RowDataKey from, RowDataKey reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return this.serializer.getLength();
    }

    public void serialize(RowDataKey record, DataOutputView target) throws IOException {
        this.serializer.serialize((Object)record.rowData, target);
    }

    public RowDataKey deserialize(DataInputView source) throws IOException {
        return RowDataKey.toKeyNotProjected((RowData)this.serializer.deserialize(source), this.equalizerInstance, this.hashFunctionInstance);
    }

    public RowDataKey deserialize(RowDataKey reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serializer.copy(source, target);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RowDataKeySerializer) {
            RowDataKeySerializer other = (RowDataKeySerializer)((Object)obj);
            return this.serializer.equals(other.serializer) && this.equalizerInstance.equals(other.equalizerInstance) && this.hashFunctionInstance.equals(other.hashFunctionInstance);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.serializer, this.equalizerInstance, this.hashFunctionInstance);
    }

    public TypeSerializerSnapshot<RowDataKey> snapshotConfiguration() {
        return new RowDataKeySerializerSnapshot(this);
    }
}

