/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank.async;

import java.util.Objects;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.state.v2.ValueState;
import org.apache.flink.api.common.state.v2.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncStateTopNFunction
extends AbstractTopNFunction {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAsyncStateTopNFunction.class);
    private ValueState<Long> rankEndState;

    public AbstractAsyncStateTopNFunction(StateTtlConfig ttlConfig, InternalTypeInfo<RowData> inputRowType, GeneratedRecordComparator generatedSortKeyComparator, RowDataKeySelector sortKeySelector, RankType rankType, RankRange rankRange, boolean generateUpdateBefore, boolean outputRankNumber) {
        super(ttlConfig, inputRowType, generatedSortKeyComparator, sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber);
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        LOG.info("Top-N is using async state");
        if (!this.isConstantRankEnd) {
            ValueStateDescriptor rankStateDesc = new ValueStateDescriptor("rankEnd", Types.LONG);
            if (this.ttlConfig.isEnabled()) {
                rankStateDesc.enableTimeToLive(this.ttlConfig);
            }
            this.rankEndState = this.getRuntimeContext().getState(rankStateDesc);
        }
    }

    protected StateFuture<Long> initRankEnd(RowData row) {
        if (this.isConstantRankEnd) {
            return StateFutureUtils.completedFuture((Object)Objects.requireNonNull(this.constantRankEnd));
        }
        return this.rankEndState.asyncValue().thenApply(rankEndInState -> {
            long curRankEnd = (Long)this.rankEndFetcher.apply(row);
            if (rankEndInState == null) {
                this.rankEndState.asyncUpdate((Object)curRankEnd);
                return curRankEnd;
            }
            if (rankEndInState != curRankEnd) {
                this.invalidCounter.inc();
            }
            return rankEndInState;
        });
    }
}

