/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public class ArrayAppendFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter elementGetter;

    public ArrayAppendFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ARRAY_APPEND, context);
        DataType dataType = ((CollectionDataType)context.getCallContext().getArgumentDataTypes().get(0)).getElementDataType();
        this.elementGetter = ArrayData.createElementGetter((LogicalType)dataType.getLogicalType());
    }

    @Nullable
    public ArrayData eval(@Nullable ArrayData array, Object element) {
        if (array == null) {
            return null;
        }
        int size = array.size();
        Object[] data = new Object[size + 1];
        for (int pos = 0; pos < size; ++pos) {
            data[pos] = this.elementGetter.getElementOrNull(array, pos);
        }
        data[size] = element;
        return new GenericArrayData(data);
    }
}

