/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.sql.Timestamp;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;

@Internal
public final class TemporalTableFunctionImpl
extends TemporalTableFunction {
    private final transient QueryOperation underlyingHistoryTable;
    private final transient Expression timeAttribute;
    private final transient Expression primaryKey;
    private final TypeInformation<Row> resultType;

    private TemporalTableFunctionImpl(QueryOperation underlyingHistoryTable, Expression timeAttribute, Expression primaryKey, TypeInformation<Row> resultType) {
        this.underlyingHistoryTable = underlyingHistoryTable;
        this.timeAttribute = timeAttribute;
        this.primaryKey = primaryKey;
        this.resultType = resultType;
    }

    public void eval(Timestamp t) {
        throw new IllegalStateException("This should never be called");
    }

    public Expression getTimeAttribute() {
        return this.timeAttribute;
    }

    public Expression getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        ResolvedSchema resolvedSchema = this.underlyingHistoryTable.getResolvedSchema();
        return TypeInference.newBuilder().inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.explicit(DataTypes.TIMESTAMP(3))), InputTypeStrategies.sequence(InputTypeStrategies.explicit(DataTypes.TIMESTAMP_LTZ(3))))).outputTypeStrategy(TypeStrategies.explicit(DataTypeUtils.fromResolvedSchemaPreservingTimeAttributes(resolvedSchema))).build();
    }

    @Override
    public TypeInformation<Row> getResultType() {
        return this.resultType;
    }

    public QueryOperation getUnderlyingHistoryTable() {
        if (this.underlyingHistoryTable == null) {
            throw new IllegalStateException("Accessing table field after planing/serialization");
        }
        return this.underlyingHistoryTable;
    }

    public static TemporalTableFunction create(QueryOperation operationTree, Expression timeAttribute, Expression primaryKey) {
        return new TemporalTableFunctionImpl(operationTree, timeAttribute, primaryKey, TypeConversions.fromDataTypeToLegacyInfo(DataTypeUtils.fromResolvedSchemaPreservingTimeAttributes(operationTree.getResolvedSchema())));
    }
}

