/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source.lookup.cache.trigger;

import java.time.Clock;
import java.time.Duration;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.trigger.CacheReloadTrigger;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class TimedCacheReloadTrigger
implements CacheReloadTrigger {
    private static final long serialVersionUID = 1L;
    private final Temporal reloadTime;
    private final int reloadIntervalInDays;
    private transient ScheduledExecutorService scheduledExecutor;
    private transient Clock clock;

    public TimedCacheReloadTrigger(OffsetTime reloadTime, int reloadIntervalInDays) {
        this((Temporal)reloadTime, reloadIntervalInDays);
    }

    public TimedCacheReloadTrigger(LocalTime reloadTime, int reloadIntervalInDays) {
        this((Temporal)reloadTime, reloadIntervalInDays);
    }

    private TimedCacheReloadTrigger(Temporal reloadTime, int reloadIntervalInDays) {
        Preconditions.checkArgument((reloadIntervalInDays > 0 ? 1 : 0) != 0, (Object)"Reload interval for Timed cache reload trigger must be at least 1 day.");
        this.reloadTime = reloadTime;
        this.reloadIntervalInDays = reloadIntervalInDays;
    }

    @VisibleForTesting
    TimedCacheReloadTrigger(Temporal reloadTime, int reloadIntervalInDays, ScheduledExecutorService scheduledExecutor, Clock clock) {
        this(reloadTime, reloadIntervalInDays);
        this.scheduledExecutor = scheduledExecutor;
        this.clock = clock;
    }

    @Override
    public void open(CacheReloadTrigger.Context context) {
        Comparable<LocalTime> now;
        Duration initialDelayDuration;
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        }
        if (this.clock == null) {
            this.clock = this.reloadTime instanceof LocalTime ? Clock.systemDefaultZone() : Clock.system(((OffsetTime)this.reloadTime).getOffset());
        }
        if ((initialDelayDuration = Duration.between(now = this.reloadTime instanceof LocalTime ? LocalTime.now(this.clock) : OffsetTime.now(this.clock), this.reloadTime)).isNegative()) {
            initialDelayDuration = initialDelayDuration.plus(1L, ChronoUnit.DAYS);
        }
        this.scheduledExecutor.execute(context::triggerReload);
        this.scheduledExecutor.scheduleAtFixedRate(context::triggerReload, initialDelayDuration.toMillis(), Duration.ofDays(this.reloadIntervalInDays).toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws Exception {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
    }

    @VisibleForTesting
    Temporal getReloadTime() {
        return this.reloadTime;
    }

    public static TimedCacheReloadTrigger fromConfig(ReadableConfig config) {
        Preconditions.checkArgument((config.get(LookupOptions.CACHE_TYPE) == LookupOptions.LookupCacheType.FULL ? 1 : 0) != 0, (String)"'%s' should be '%s' in order to build a Timed cache reload trigger.", (Object[])new Object[]{LookupOptions.CACHE_TYPE.key(), LookupOptions.LookupCacheType.FULL});
        Preconditions.checkArgument((config.get(LookupOptions.FULL_CACHE_RELOAD_STRATEGY) == LookupOptions.ReloadStrategy.TIMED ? 1 : 0) != 0, (String)"'%s' should be '%s' in order to build a Timed cache reload trigger.", (Object[])new Object[]{LookupOptions.FULL_CACHE_RELOAD_STRATEGY.key(), LookupOptions.ReloadStrategy.TIMED});
        Preconditions.checkArgument((boolean)config.getOptional(LookupOptions.FULL_CACHE_TIMED_RELOAD_ISO_TIME).isPresent(), (String)"Missing '%s' in the configuration. This option is required to build a Timed cache reload trigger.", (Object[])new Object[]{LookupOptions.FULL_CACHE_TIMED_RELOAD_ISO_TIME.key()});
        Temporal reloadTime = (Temporal)DateTimeFormatter.ISO_TIME.parseBest((CharSequence)config.get(LookupOptions.FULL_CACHE_TIMED_RELOAD_ISO_TIME), OffsetTime::from, LocalTime::from);
        int reloadIntervalInDays = (Integer)config.get(LookupOptions.FULL_CACHE_TIMED_RELOAD_INTERVAL_IN_DAYS);
        return new TimedCacheReloadTrigger(reloadTime, reloadIntervalInDays);
    }
}

