/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@Internal
public final class ContextResolvedFunction {
    private final boolean isTemporary;
    @Nullable
    private final FunctionIdentifier functionIdentifier;
    private final FunctionDefinition functionDefinition;
    @Nullable
    private final CatalogFunction catalogFunction;

    public static ContextResolvedFunction permanent(FunctionIdentifier functionIdentifier, FunctionDefinition functionDefinition) {
        Preconditions.checkNotNull((Object)functionIdentifier, (String)"Function identifier should not be null for a permanent function.");
        return new ContextResolvedFunction(false, functionIdentifier, functionDefinition, null);
    }

    public static ContextResolvedFunction permanent(FunctionIdentifier functionIdentifier, FunctionDefinition functionDefinition, CatalogFunction catalogFunction) {
        Preconditions.checkNotNull((Object)functionIdentifier, (String)"Function identifier should not be null for a permanent function.");
        return new ContextResolvedFunction(false, functionIdentifier, functionDefinition, catalogFunction);
    }

    public static ContextResolvedFunction temporary(FunctionIdentifier functionIdentifier, FunctionDefinition functionDefinition) {
        Preconditions.checkNotNull((Object)functionIdentifier, (String)"Function identifier should not be null for a temporary function.");
        return new ContextResolvedFunction(true, functionIdentifier, functionDefinition, null);
    }

    public static ContextResolvedFunction temporary(FunctionIdentifier functionIdentifier, FunctionDefinition functionDefinition, CatalogFunction catalogFunction) {
        Preconditions.checkNotNull((Object)functionIdentifier, (String)"Function identifier should not be null for a temporary function.");
        return new ContextResolvedFunction(true, functionIdentifier, functionDefinition, catalogFunction);
    }

    public static ContextResolvedFunction anonymous(FunctionDefinition functionDefinition) {
        return new ContextResolvedFunction(true, null, functionDefinition, null);
    }

    public static ContextResolvedFunction fromCallExpression(CallExpression callExpression) {
        return new ContextResolvedFunction(callExpression.isTemporary(), callExpression.getFunctionIdentifier().orElse(null), callExpression.getFunctionDefinition(), null);
    }

    private ContextResolvedFunction(boolean isTemporary, @Nullable FunctionIdentifier functionIdentifier, FunctionDefinition functionDefinition, @Nullable CatalogFunction catalogFunction) {
        this.isTemporary = isTemporary;
        this.functionIdentifier = functionIdentifier;
        this.functionDefinition = (FunctionDefinition)Preconditions.checkNotNull((Object)functionDefinition, (String)"Function definition must not be null.");
        this.catalogFunction = catalogFunction;
    }

    public boolean isAnonymous() {
        return this.functionIdentifier == null;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public boolean isPermanent() {
        return !this.isTemporary;
    }

    public Optional<FunctionIdentifier> getIdentifier() {
        return Optional.ofNullable(this.functionIdentifier);
    }

    public FunctionDefinition getDefinition() {
        return this.functionDefinition;
    }

    public CatalogFunction getCatalogFunction() {
        return this.catalogFunction;
    }

    public String asSummaryString() {
        if (this.functionIdentifier == null) {
            return this.functionDefinition.toString();
        }
        return this.functionIdentifier.asSummaryString();
    }

    public CallExpression toCallExpression(List<ResolvedExpression> resolvedArgs, DataType outputDataType) {
        return new CallExpression(this.isTemporary, this.functionIdentifier, this.functionDefinition, resolvedArgs, outputDataType);
    }

    public String toString() {
        if (this.functionIdentifier != null) {
            return this.functionIdentifier.asSummaryString();
        }
        return this.functionDefinition.toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextResolvedFunction that = (ContextResolvedFunction)o;
        return this.isTemporary == that.isTemporary && Objects.equals(this.functionIdentifier, that.functionIdentifier) && this.functionDefinition.equals(that.functionDefinition) && Objects.equals(this.catalogFunction, that.catalogFunction);
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.isTemporary);
        result = 31 * result + Objects.hashCode(this.functionIdentifier);
        result = 31 * result + this.functionDefinition.hashCode();
        result = 31 * result + Objects.hashCode(this.catalogFunction);
        return result;
    }
}

