/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.bash;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.jobmanager.JobManagerProcessSpec;
import org.apache.flink.runtime.jobmanager.JobManagerProcessUtils;
import org.apache.flink.runtime.util.bash.BashJavaUtils;
import org.apache.flink.runtime.util.bash.FlinkConfigLoader;
import org.apache.flink.runtime.util.config.memory.ProcessMemorySpec;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtils;
import org.apache.flink.runtime.util.config.memory.jobmanager.JobManagerFlinkMemory;
import org.apache.flink.runtime.util.config.memory.taskmanager.TaskExecutorFlinkMemory;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BashJavaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BashJavaUtils.class);
    @VisibleForTesting
    public static final String EXECUTION_PREFIX = "BASH_JAVA_UTILS_EXEC_RESULT:";

    private BashJavaUtils() {
    }

    public static void main(String[] args) throws FlinkException {
        Preconditions.checkArgument((args.length > 0 ? 1 : 0) != 0, (Object)"Command not specified.");
        Command command = Command.valueOf((String)args[0]);
        String[] commandArgs = Arrays.copyOfRange(args, 1, args.length);
        List<String> output = BashJavaUtils.runCommand(command, commandArgs);
        for (String outputLine : output) {
            System.out.println("BASH_JAVA_UTILS_EXEC_RESULT:" + outputLine);
        }
    }

    private static List<String> runCommand(Command command, String[] commandArgs) throws FlinkException {
        switch (1.$SwitchMap$org$apache$flink$runtime$util$bash$BashJavaUtils$Command[command.ordinal()]) {
            case 1: {
                return BashJavaUtils.getTmResourceParams(FlinkConfigLoader.loadConfiguration((String[])commandArgs));
            }
            case 2: {
                return BashJavaUtils.getJmResourceParams(FlinkConfigLoader.loadConfiguration((String[])commandArgs));
            }
            case 3: {
                return FlinkConfigLoader.loadAndModifyConfiguration((String[])commandArgs);
            }
            case 4: {
                return FlinkConfigLoader.migrateLegacyConfigurationToStandardYaml((String[])commandArgs);
            }
        }
        throw new RuntimeException("Unexpected, something is wrong.");
    }

    private static List<String> getTmResourceParams(Configuration configuration) {
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)configuration);
        BashJavaUtils.logTaskExecutorConfiguration(taskExecutorProcessSpec);
        return Arrays.asList(ProcessMemoryUtils.generateJvmParametersStr((ProcessMemorySpec)taskExecutorProcessSpec), TaskExecutorProcessUtils.generateDynamicConfigsStr((TaskExecutorProcessSpec)taskExecutorProcessSpec));
    }

    @VisibleForTesting
    static List<String> getJmResourceParams(Configuration configuration) {
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)configuration);
        BashJavaUtils.logMasterConfiguration(jobManagerProcessSpec);
        return Arrays.asList(JobManagerProcessUtils.generateJvmParametersStr((JobManagerProcessSpec)jobManagerProcessSpec, (Configuration)configuration), JobManagerProcessUtils.generateDynamicConfigsStr((JobManagerProcessSpec)jobManagerProcessSpec));
    }

    private static void logMasterConfiguration(JobManagerProcessSpec spec) {
        JobManagerFlinkMemory flinkMemory = (JobManagerFlinkMemory)spec.getFlinkMemory();
        LOG.info("Final Master Memory configuration:");
        LOG.info("  Total Process Memory: {}", (Object)spec.getTotalProcessMemorySize().toHumanReadableString());
        LOG.info("    Total Flink Memory: {}", (Object)flinkMemory.getTotalFlinkMemorySize().toHumanReadableString());
        LOG.info("      JVM Heap:         {}", (Object)flinkMemory.getJvmHeapMemorySize().toHumanReadableString());
        LOG.info("      Off-heap:         {}", (Object)flinkMemory.getJvmDirectMemorySize().toHumanReadableString());
        LOG.info("    JVM Metaspace:      {}", (Object)spec.getJvmMetaspaceSize().toHumanReadableString());
        LOG.info("    JVM Overhead:       {}", (Object)spec.getJvmOverheadSize().toHumanReadableString());
    }

    private static void logTaskExecutorConfiguration(TaskExecutorProcessSpec spec) {
        TaskExecutorFlinkMemory flinkMemory = (TaskExecutorFlinkMemory)spec.getFlinkMemory();
        MemorySize totalOffHeapMemory = flinkMemory.getManaged().add(flinkMemory.getJvmDirectMemorySize());
        LOG.info("Final TaskExecutor Memory configuration:");
        LOG.info("  Total Process Memory:          {}", (Object)spec.getTotalProcessMemorySize().toHumanReadableString());
        LOG.info("    Total Flink Memory:          {}", (Object)flinkMemory.getTotalFlinkMemorySize().toHumanReadableString());
        LOG.info("      Total JVM Heap Memory:     {}", (Object)flinkMemory.getJvmHeapMemorySize().toHumanReadableString());
        LOG.info("        Framework:               {}", (Object)flinkMemory.getFrameworkHeap().toHumanReadableString());
        LOG.info("        Task:                    {}", (Object)flinkMemory.getTaskHeap().toHumanReadableString());
        LOG.info("      Total Off-heap Memory:     {}", (Object)totalOffHeapMemory.toHumanReadableString());
        LOG.info("        Managed:                 {}", (Object)flinkMemory.getManaged().toHumanReadableString());
        LOG.info("        Total JVM Direct Memory: {}", (Object)flinkMemory.getJvmDirectMemorySize().toHumanReadableString());
        LOG.info("          Framework:             {}", (Object)flinkMemory.getFrameworkOffHeap().toHumanReadableString());
        LOG.info("          Task:                  {}", (Object)flinkMemory.getTaskOffHeap().toHumanReadableString());
        LOG.info("          Network:               {}", (Object)flinkMemory.getNetwork().toHumanReadableString());
        LOG.info("    JVM Metaspace:               {}", (Object)spec.getJvmMetaspaceSize().toHumanReadableString());
        LOG.info("    JVM Overhead:                {}", (Object)spec.getJvmOverheadSize().toHumanReadableString());
    }
}

