/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.31.1(337587859b1c171314b40503171188b6cea6a32a)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
define("vs/language/json/jsonMode",[],()=>{
var moduleExports=(()=>{var mn=Object.create;var X=Object.defineProperty;var vn=Object.getOwnPropertyDescriptor;var kn=Object.getOwnPropertyNames;var yn=Object.getPrototypeOf,Tn=Object.prototype.hasOwnProperty;var ie=e=>X(e,"__esModule",{value:!0});var bn=(e,t)=>()=>(t||e((t={exports:{}}).exports,t),t.exports),Cn=(e,t)=>{ie(e);for(var i in t)X(e,i,{get:t[i],enumerable:!0})},ae=(e,t,i)=>{if(t&&typeof t=="object"||typeof t=="function")for(let r of kn(t))!Tn.call(e,r)&&r!=="default"&&X(e,r,{get:()=>t[r],enumerable:!(i=vn(t,r))||i.enumerable});return e},wn=e=>ae(ie(X(e!=null?mn(yn(e)):{},"default",e&&e.__esModule&&"default"in e?{get:()=>e.default,enumerable:!0}:{value:e,enumerable:!0})),e);var Ee=bn((Qn,Ie)=>{Ie.exports=self.monaco});var $n={};Cn($n,{setupMode:()=>Xn});var l={};ie(l);ae(l,wn(Ee()));var In=2*60*1e3,oe=class{constructor(t){this._defaults=t,this._worker=null,this._client=null,this._idleCheckInterval=window.setInterval(()=>this._checkIfIdle(),30*1e3),this._lastUsedTime=0,this._configChangeListener=this._defaults.onDidChange(()=>this._stopWorker())}_stopWorker(){this._worker&&(this._worker.dispose(),this._worker=null),this._client=null}dispose(){clearInterval(this._idleCheckInterval),this._configChangeListener.dispose(),this._stopWorker()}_checkIfIdle(){if(!this._worker)return;Date.now()-this._lastUsedTime>In&&this._stopWorker()}_getClient(){return this._lastUsedTime=Date.now(),this._client||(this._worker=l.editor.createWebWorker({moduleId:"vs/language/json/jsonWorker",label:this._defaults.languageId,createData:{languageSettings:this._defaults.diagnosticsOptions,languageId:this._defaults.languageId,enableSchemaRequest:this._defaults.diagnosticsOptions.enableSchemaRequest}}),this._client=this._worker.getProxy()),this._client}getLanguageServiceWorker(...t){let i;return this._getClient().then(r=>{i=r}).then(r=>{if(this._worker)return this._worker.withSyncedResources(t)}).then(r=>i)}};"use strict";var xe;(function(e){e.MIN_VALUE=-2147483648,e.MAX_VALUE=2147483647})(xe||(xe={}));var Y;(function(e){e.MIN_VALUE=0,e.MAX_VALUE=2147483647})(Y||(Y={}));var A;(function(e){function t(r,n){return r===Number.MAX_VALUE&&(r=Y.MAX_VALUE),n===Number.MAX_VALUE&&(n=Y.MAX_VALUE),{line:r,character:n}}e.create=t;function i(r){var n=r;return s.objectLiteral(n)&&s.uinteger(n.line)&&s.uinteger(n.character)}e.is=i})(A||(A={}));var y;(function(e){function t(r,n,a,o){if(s.uinteger(r)&&s.uinteger(n)&&s.uinteger(a)&&s.uinteger(o))return{start:A.create(r,n),end:A.create(a,o)};if(A.is(r)&&A.is(n))return{start:r,end:n};throw new Error("Range#create called with invalid arguments["+r+", "+n+", "+a+", "+o+"]")}e.create=t;function i(r){var n=r;return s.objectLiteral(n)&&A.is(n.start)&&A.is(n.end)}e.is=i})(y||(y={}));var se;(function(e){function t(r,n){return{uri:r,range:n}}e.create=t;function i(r){var n=r;return s.defined(n)&&y.is(n.range)&&(s.string(n.uri)||s.undefined(n.uri))}e.is=i})(se||(se={}));var _e;(function(e){function t(r,n,a,o){return{targetUri:r,targetRange:n,targetSelectionRange:a,originSelectionRange:o}}e.create=t;function i(r){var n=r;return s.defined(n)&&y.is(n.targetRange)&&s.string(n.targetUri)&&(y.is(n.targetSelectionRange)||s.undefined(n.targetSelectionRange))&&(y.is(n.originSelectionRange)||s.undefined(n.originSelectionRange))}e.is=i})(_e||(_e={}));var ue;(function(e){function t(r,n,a,o){return{red:r,green:n,blue:a,alpha:o}}e.create=t;function i(r){var n=r;return s.numberRange(n.red,0,1)&&s.numberRange(n.green,0,1)&&s.numberRange(n.blue,0,1)&&s.numberRange(n.alpha,0,1)}e.is=i})(ue||(ue={}));var Ae;(function(e){function t(r,n){return{range:r,color:n}}e.create=t;function i(r){var n=r;return y.is(n.range)&&ue.is(n.color)}e.is=i})(Ae||(Ae={}));var Pe;(function(e){function t(r,n,a){return{label:r,textEdit:n,additionalTextEdits:a}}e.create=t;function i(r){var n=r;return s.string(n.label)&&(s.undefined(n.textEdit)||L.is(n))&&(s.undefined(n.additionalTextEdits)||s.typedArray(n.additionalTextEdits,L.is))}e.is=i})(Pe||(Pe={}));var D;(function(e){e.Comment="comment",e.Imports="imports",e.Region="region"})(D||(D={}));var Le;(function(e){function t(r,n,a,o,u){var c={startLine:r,endLine:n};return s.defined(a)&&(c.startCharacter=a),s.defined(o)&&(c.endCharacter=o),s.defined(u)&&(c.kind=u),c}e.create=t;function i(r){var n=r;return s.uinteger(n.startLine)&&s.uinteger(n.startLine)&&(s.undefined(n.startCharacter)||s.uinteger(n.startCharacter))&&(s.undefined(n.endCharacter)||s.uinteger(n.endCharacter))&&(s.undefined(n.kind)||s.string(n.kind))}e.is=i})(Le||(Le={}));var ce;(function(e){function t(r,n){return{location:r,message:n}}e.create=t;function i(r){var n=r;return s.defined(n)&&se.is(n.location)&&s.string(n.message)}e.is=i})(ce||(ce={}));var O;(function(e){e.Error=1,e.Warning=2,e.Information=3,e.Hint=4})(O||(O={}));var Se;(function(e){e.Unnecessary=1,e.Deprecated=2})(Se||(Se={}));var Re;(function(e){function t(i){var r=i;return r!=null&&s.string(r.href)}e.is=t})(Re||(Re={}));var $;(function(e){function t(r,n,a,o,u,c){var m={range:r,message:n};return s.defined(a)&&(m.severity=a),s.defined(o)&&(m.code=o),s.defined(u)&&(m.source=u),s.defined(c)&&(m.relatedInformation=c),m}e.create=t;function i(r){var n,a=r;return s.defined(a)&&y.is(a.range)&&s.string(a.message)&&(s.number(a.severity)||s.undefined(a.severity))&&(s.integer(a.code)||s.string(a.code)||s.undefined(a.code))&&(s.undefined(a.codeDescription)||s.string((n=a.codeDescription)===null||n===void 0?void 0:n.href))&&(s.string(a.source)||s.undefined(a.source))&&(s.undefined(a.relatedInformation)||s.typedArray(a.relatedInformation,ce.is))}e.is=i})($||($={}));var V;(function(e){function t(r,n){for(var a=[],o=2;o<arguments.length;o++)a[o-2]=arguments[o];var u={title:r,command:n};return s.defined(a)&&a.length>0&&(u.arguments=a),u}e.create=t;function i(r){var n=r;return s.defined(n)&&s.string(n.title)&&s.string(n.command)}e.is=i})(V||(V={}));var L;(function(e){function t(a,o){return{range:a,newText:o}}e.replace=t;function i(a,o){return{range:{start:a,end:a},newText:o}}e.insert=i;function r(a){return{range:a,newText:""}}e.del=r;function n(a){var o=a;return s.objectLiteral(o)&&s.string(o.newText)&&y.is(o.range)}e.is=n})(L||(L={}));var N;(function(e){function t(r,n,a){var o={label:r};return n!==void 0&&(o.needsConfirmation=n),a!==void 0&&(o.description=a),o}e.create=t;function i(r){var n=r;return n!==void 0&&s.objectLiteral(n)&&s.string(n.label)&&(s.boolean(n.needsConfirmation)||n.needsConfirmation===void 0)&&(s.string(n.description)||n.description===void 0)}e.is=i})(N||(N={}));var b;(function(e){function t(i){var r=i;return typeof r=="string"}e.is=t})(b||(b={}));var S;(function(e){function t(a,o,u){return{range:a,newText:o,annotationId:u}}e.replace=t;function i(a,o,u){return{range:{start:a,end:a},newText:o,annotationId:u}}e.insert=i;function r(a,o){return{range:a,newText:"",annotationId:o}}e.del=r;function n(a){var o=a;return L.is(o)&&(N.is(o.annotationId)||b.is(o.annotationId))}e.is=n})(S||(S={}));var G;(function(e){function t(r,n){return{textDocument:r,edits:n}}e.create=t;function i(r){var n=r;return s.defined(n)&&Z.is(n.textDocument)&&Array.isArray(n.edits)}e.is=i})(G||(G={}));var H;(function(e){function t(r,n,a){var o={kind:"create",uri:r};return n!==void 0&&(n.overwrite!==void 0||n.ignoreIfExists!==void 0)&&(o.options=n),a!==void 0&&(o.annotationId=a),o}e.create=t;function i(r){var n=r;return n&&n.kind==="create"&&s.string(n.uri)&&(n.options===void 0||(n.options.overwrite===void 0||s.boolean(n.options.overwrite))&&(n.options.ignoreIfExists===void 0||s.boolean(n.options.ignoreIfExists)))&&(n.annotationId===void 0||b.is(n.annotationId))}e.is=i})(H||(H={}));var K;(function(e){function t(r,n,a,o){var u={kind:"rename",oldUri:r,newUri:n};return a!==void 0&&(a.overwrite!==void 0||a.ignoreIfExists!==void 0)&&(u.options=a),o!==void 0&&(u.annotationId=o),u}e.create=t;function i(r){var n=r;return n&&n.kind==="rename"&&s.string(n.oldUri)&&s.string(n.newUri)&&(n.options===void 0||(n.options.overwrite===void 0||s.boolean(n.options.overwrite))&&(n.options.ignoreIfExists===void 0||s.boolean(n.options.ignoreIfExists)))&&(n.annotationId===void 0||b.is(n.annotationId))}e.is=i})(K||(K={}));var z;(function(e){function t(r,n,a){var o={kind:"delete",uri:r};return n!==void 0&&(n.recursive!==void 0||n.ignoreIfNotExists!==void 0)&&(o.options=n),a!==void 0&&(o.annotationId=a),o}e.create=t;function i(r){var n=r;return n&&n.kind==="delete"&&s.string(n.uri)&&(n.options===void 0||(n.options.recursive===void 0||s.boolean(n.options.recursive))&&(n.options.ignoreIfNotExists===void 0||s.boolean(n.options.ignoreIfNotExists)))&&(n.annotationId===void 0||b.is(n.annotationId))}e.is=i})(z||(z={}));var le;(function(e){function t(i){var r=i;return r&&(r.changes!==void 0||r.documentChanges!==void 0)&&(r.documentChanges===void 0||r.documentChanges.every(function(n){return s.string(n.kind)?H.is(n)||K.is(n)||z.is(n):G.is(n)}))}e.is=t})(le||(le={}));var Q=function(){function e(t,i){this.edits=t,this.changeAnnotations=i}return e.prototype.insert=function(t,i,r){var n,a;if(r===void 0?n=L.insert(t,i):b.is(r)?(a=r,n=S.insert(t,i,r)):(this.assertChangeAnnotations(this.changeAnnotations),a=this.changeAnnotations.manage(r),n=S.insert(t,i,a)),this.edits.push(n),a!==void 0)return a},e.prototype.replace=function(t,i,r){var n,a;if(r===void 0?n=L.replace(t,i):b.is(r)?(a=r,n=S.replace(t,i,r)):(this.assertChangeAnnotations(this.changeAnnotations),a=this.changeAnnotations.manage(r),n=S.replace(t,i,a)),this.edits.push(n),a!==void 0)return a},e.prototype.delete=function(t,i){var r,n;if(i===void 0?r=L.del(t):b.is(i)?(n=i,r=S.del(t,i)):(this.assertChangeAnnotations(this.changeAnnotations),n=this.changeAnnotations.manage(i),r=S.del(t,n)),this.edits.push(r),n!==void 0)return n},e.prototype.add=function(t){this.edits.push(t)},e.prototype.all=function(){return this.edits},e.prototype.clear=function(){this.edits.splice(0,this.edits.length)},e.prototype.assertChangeAnnotations=function(t){if(t===void 0)throw new Error("Text edit change is not configured to manage change annotations.")},e}(),Oe=function(){function e(t){this._annotations=t===void 0?Object.create(null):t,this._counter=0,this._size=0}return e.prototype.all=function(){return this._annotations},Object.defineProperty(e.prototype,"size",{get:function(){return this._size},enumerable:!1,configurable:!0}),e.prototype.manage=function(t,i){var r;if(b.is(t)?r=t:(r=this.nextId(),i=t),this._annotations[r]!==void 0)throw new Error("Id "+r+" is already in use.");if(i===void 0)throw new Error("No annotation provided for id "+r);return this._annotations[r]=i,this._size++,r},e.prototype.nextId=function(){return this._counter++,this._counter.toString()},e}(),ir=function(){function e(t){var i=this;this._textEditChanges=Object.create(null),t!==void 0?(this._workspaceEdit=t,t.documentChanges?(this._changeAnnotations=new Oe(t.changeAnnotations),t.changeAnnotations=this._changeAnnotations.all(),t.documentChanges.forEach(function(r){if(G.is(r)){var n=new Q(r.edits,i._changeAnnotations);i._textEditChanges[r.textDocument.uri]=n}})):t.changes&&Object.keys(t.changes).forEach(function(r){var n=new Q(t.changes[r]);i._textEditChanges[r]=n})):this._workspaceEdit={}}return Object.defineProperty(e.prototype,"edit",{get:function(){return this.initDocumentChanges(),this._changeAnnotations!==void 0&&(this._changeAnnotations.size===0?this._workspaceEdit.changeAnnotations=void 0:this._workspaceEdit.changeAnnotations=this._changeAnnotations.all()),this._workspaceEdit},enumerable:!1,configurable:!0}),e.prototype.getTextEditChange=function(t){if(Z.is(t)){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var i={uri:t.uri,version:t.version},r=this._textEditChanges[i.uri];if(!r){var n=[],a={textDocument:i,edits:n};this._workspaceEdit.documentChanges.push(a),r=new Q(n,this._changeAnnotations),this._textEditChanges[i.uri]=r}return r}else{if(this.initChanges(),this._workspaceEdit.changes===void 0)throw new Error("Workspace edit is not configured for normal text edit changes.");var r=this._textEditChanges[t];if(!r){var n=[];this._workspaceEdit.changes[t]=n,r=new Q(n),this._textEditChanges[t]=r}return r}},e.prototype.initDocumentChanges=function(){this._workspaceEdit.documentChanges===void 0&&this._workspaceEdit.changes===void 0&&(this._changeAnnotations=new Oe,this._workspaceEdit.documentChanges=[],this._workspaceEdit.changeAnnotations=this._changeAnnotations.all())},e.prototype.initChanges=function(){this._workspaceEdit.documentChanges===void 0&&this._workspaceEdit.changes===void 0&&(this._workspaceEdit.changes=Object.create(null))},e.prototype.createFile=function(t,i,r){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var n;N.is(i)||b.is(i)?n=i:r=i;var a,o;if(n===void 0?a=H.create(t,r):(o=b.is(n)?n:this._changeAnnotations.manage(n),a=H.create(t,r,o)),this._workspaceEdit.documentChanges.push(a),o!==void 0)return o},e.prototype.renameFile=function(t,i,r,n){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var a;N.is(r)||b.is(r)?a=r:n=r;var o,u;if(a===void 0?o=K.create(t,i,n):(u=b.is(a)?a:this._changeAnnotations.manage(a),o=K.create(t,i,n,u)),this._workspaceEdit.documentChanges.push(o),u!==void 0)return u},e.prototype.deleteFile=function(t,i,r){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var n;N.is(i)||b.is(i)?n=i:r=i;var a,o;if(n===void 0?a=z.create(t,r):(o=b.is(n)?n:this._changeAnnotations.manage(n),a=z.create(t,r,o)),this._workspaceEdit.documentChanges.push(a),o!==void 0)return o},e}();var We;(function(e){function t(r){return{uri:r}}e.create=t;function i(r){var n=r;return s.defined(n)&&s.string(n.uri)}e.is=i})(We||(We={}));var De;(function(e){function t(r,n){return{uri:r,version:n}}e.create=t;function i(r){var n=r;return s.defined(n)&&s.string(n.uri)&&s.integer(n.version)}e.is=i})(De||(De={}));var Z;(function(e){function t(r,n){return{uri:r,version:n}}e.create=t;function i(r){var n=r;return s.defined(n)&&s.string(n.uri)&&(n.version===null||s.integer(n.version))}e.is=i})(Z||(Z={}));var Ne;(function(e){function t(r,n,a,o){return{uri:r,languageId:n,version:a,text:o}}e.create=t;function i(r){var n=r;return s.defined(n)&&s.string(n.uri)&&s.string(n.languageId)&&s.integer(n.version)&&s.string(n.text)}e.is=i})(Ne||(Ne={}));var B;(function(e){e.PlainText="plaintext",e.Markdown="markdown"})(B||(B={}));(function(e){function t(i){var r=i;return r===e.PlainText||r===e.Markdown}e.is=t})(B||(B={}));var fe;(function(e){function t(i){var r=i;return s.objectLiteral(i)&&B.is(r.kind)&&s.string(r.value)}e.is=t})(fe||(fe={}));var v;(function(e){e.Text=1,e.Method=2,e.Function=3,e.Constructor=4,e.Field=5,e.Variable=6,e.Class=7,e.Interface=8,e.Module=9,e.Property=10,e.Unit=11,e.Value=12,e.Enum=13,e.Keyword=14,e.Snippet=15,e.Color=16,e.File=17,e.Reference=18,e.Folder=19,e.EnumMember=20,e.Constant=21,e.Struct=22,e.Event=23,e.Operator=24,e.TypeParameter=25})(v||(v={}));var ee;(function(e){e.PlainText=1,e.Snippet=2})(ee||(ee={}));var Fe;(function(e){e.Deprecated=1})(Fe||(Fe={}));var Me;(function(e){function t(r,n,a){return{newText:r,insert:n,replace:a}}e.create=t;function i(r){var n=r;return n&&s.string(n.newText)&&y.is(n.insert)&&y.is(n.replace)}e.is=i})(Me||(Me={}));var je;(function(e){e.asIs=1,e.adjustIndentation=2})(je||(je={}));var Ue;(function(e){function t(i){return{label:i}}e.create=t})(Ue||(Ue={}));var Ve;(function(e){function t(i,r){return{items:i||[],isIncomplete:!!r}}e.create=t})(Ve||(Ve={}));var ne;(function(e){function t(r){return r.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")}e.fromPlainText=t;function i(r){var n=r;return s.string(n)||s.objectLiteral(n)&&s.string(n.language)&&s.string(n.value)}e.is=i})(ne||(ne={}));var He;(function(e){function t(i){var r=i;return!!r&&s.objectLiteral(r)&&(fe.is(r.contents)||ne.is(r.contents)||s.typedArray(r.contents,ne.is))&&(i.range===void 0||y.is(i.range))}e.is=t})(He||(He={}));var Ke;(function(e){function t(i,r){return r?{label:i,documentation:r}:{label:i}}e.create=t})(Ke||(Ke={}));var ze;(function(e){function t(i,r){for(var n=[],a=2;a<arguments.length;a++)n[a-2]=arguments[a];var o={label:i};return s.defined(r)&&(o.documentation=r),s.defined(n)?o.parameters=n:o.parameters=[],o}e.create=t})(ze||(ze={}));var de;(function(e){e.Text=1,e.Read=2,e.Write=3})(de||(de={}));var Be;(function(e){function t(i,r){var n={range:i};return s.number(r)&&(n.kind=r),n}e.create=t})(Be||(Be={}));var k;(function(e){e.File=1,e.Module=2,e.Namespace=3,e.Package=4,e.Class=5,e.Method=6,e.Property=7,e.Field=8,e.Constructor=9,e.Enum=10,e.Interface=11,e.Function=12,e.Variable=13,e.Constant=14,e.String=15,e.Number=16,e.Boolean=17,e.Array=18,e.Object=19,e.Key=20,e.Null=21,e.EnumMember=22,e.Struct=23,e.Event=24,e.Operator=25,e.TypeParameter=26})(k||(k={}));var Je;(function(e){e.Deprecated=1})(Je||(Je={}));var qe;(function(e){function t(i,r,n,a,o){var u={name:i,kind:r,location:{uri:a,range:n}};return o&&(u.containerName=o),u}e.create=t})(qe||(qe={}));var Xe;(function(e){function t(r,n,a,o,u,c){var m={name:r,detail:n,kind:a,range:o,selectionRange:u};return c!==void 0&&(m.children=c),m}e.create=t;function i(r){var n=r;return n&&s.string(n.name)&&s.number(n.kind)&&y.is(n.range)&&y.is(n.selectionRange)&&(n.detail===void 0||s.string(n.detail))&&(n.deprecated===void 0||s.boolean(n.deprecated))&&(n.children===void 0||Array.isArray(n.children))&&(n.tags===void 0||Array.isArray(n.tags))}e.is=i})(Xe||(Xe={}));var Ye;(function(e){e.Empty="",e.QuickFix="quickfix",e.Refactor="refactor",e.RefactorExtract="refactor.extract",e.RefactorInline="refactor.inline",e.RefactorRewrite="refactor.rewrite",e.Source="source",e.SourceOrganizeImports="source.organizeImports",e.SourceFixAll="source.fixAll"})(Ye||(Ye={}));var $e;(function(e){function t(r,n){var a={diagnostics:r};return n!=null&&(a.only=n),a}e.create=t;function i(r){var n=r;return s.defined(n)&&s.typedArray(n.diagnostics,$.is)&&(n.only===void 0||s.typedArray(n.only,s.string))}e.is=i})($e||($e={}));var Ge;(function(e){function t(r,n,a){var o={title:r},u=!0;return typeof n=="string"?(u=!1,o.kind=n):V.is(n)?o.command=n:o.edit=n,u&&a!==void 0&&(o.kind=a),o}e.create=t;function i(r){var n=r;return n&&s.string(n.title)&&(n.diagnostics===void 0||s.typedArray(n.diagnostics,$.is))&&(n.kind===void 0||s.string(n.kind))&&(n.edit!==void 0||n.command!==void 0)&&(n.command===void 0||V.is(n.command))&&(n.isPreferred===void 0||s.boolean(n.isPreferred))&&(n.edit===void 0||le.is(n.edit))}e.is=i})(Ge||(Ge={}));var Qe;(function(e){function t(r,n){var a={range:r};return s.defined(n)&&(a.data=n),a}e.create=t;function i(r){var n=r;return s.defined(n)&&y.is(n.range)&&(s.undefined(n.command)||V.is(n.command))}e.is=i})(Qe||(Qe={}));var Ze;(function(e){function t(r,n){return{tabSize:r,insertSpaces:n}}e.create=t;function i(r){var n=r;return s.defined(n)&&s.uinteger(n.tabSize)&&s.boolean(n.insertSpaces)}e.is=i})(Ze||(Ze={}));var en;(function(e){function t(r,n,a){return{range:r,target:n,data:a}}e.create=t;function i(r){var n=r;return s.defined(n)&&y.is(n.range)&&(s.undefined(n.target)||s.string(n.target))}e.is=i})(en||(en={}));var nn;(function(e){function t(r,n){return{range:r,parent:n}}e.create=t;function i(r){var n=r;return n!==void 0&&y.is(n.range)&&(n.parent===void 0||e.is(n.parent))}e.is=i})(nn||(nn={}));var rn;(function(e){function t(a,o,u,c){return new En(a,o,u,c)}e.create=t;function i(a){var o=a;return!!(s.defined(o)&&s.string(o.uri)&&(s.undefined(o.languageId)||s.string(o.languageId))&&s.uinteger(o.lineCount)&&s.func(o.getText)&&s.func(o.positionAt)&&s.func(o.offsetAt))}e.is=i;function r(a,o){for(var u=a.getText(),c=n(o,function(_,W){var U=_.range.start.line-W.range.start.line;return U===0?_.range.start.character-W.range.start.character:U}),m=u.length,p=c.length-1;p>=0;p--){var f=c[p],w=a.offsetAt(f.range.start),g=a.offsetAt(f.range.end);if(g<=m)u=u.substring(0,w)+f.newText+u.substring(g,u.length);else throw new Error("Overlapping edit");m=w}return u}e.applyEdits=r;function n(a,o){if(a.length<=1)return a;var u=a.length/2|0,c=a.slice(0,u),m=a.slice(u);n(c,o),n(m,o);for(var p=0,f=0,w=0;p<c.length&&f<m.length;){var g=o(c[p],m[f]);g<=0?a[w++]=c[p++]:a[w++]=m[f++]}for(;p<c.length;)a[w++]=c[p++];for(;f<m.length;)a[w++]=m[f++];return a}})(rn||(rn={}));var En=function(){function e(t,i,r,n){this._uri=t,this._languageId=i,this._version=r,this._content=n,this._lineOffsets=void 0}return Object.defineProperty(e.prototype,"uri",{get:function(){return this._uri},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"languageId",{get:function(){return this._languageId},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"version",{get:function(){return this._version},enumerable:!1,configurable:!0}),e.prototype.getText=function(t){if(t){var i=this.offsetAt(t.start),r=this.offsetAt(t.end);return this._content.substring(i,r)}return this._content},e.prototype.update=function(t,i){this._content=t.text,this._version=i,this._lineOffsets=void 0},e.prototype.getLineOffsets=function(){if(this._lineOffsets===void 0){for(var t=[],i=this._content,r=!0,n=0;n<i.length;n++){r&&(t.push(n),r=!1);var a=i.charAt(n);r=a==="\r"||a===`
`,a==="\r"&&n+1<i.length&&i.charAt(n+1)===`
`&&n++}r&&i.length>0&&t.push(i.length),this._lineOffsets=t}return this._lineOffsets},e.prototype.positionAt=function(t){t=Math.max(Math.min(t,this._content.length),0);var i=this.getLineOffsets(),r=0,n=i.length;if(n===0)return A.create(0,t);for(;r<n;){var a=Math.floor((r+n)/2);i[a]>t?n=a:r=a+1}var o=r-1;return A.create(o,t-i[o])},e.prototype.offsetAt=function(t){var i=this.getLineOffsets();if(t.line>=i.length)return this._content.length;if(t.line<0)return 0;var r=i[t.line],n=t.line+1<i.length?i[t.line+1]:this._content.length;return Math.max(Math.min(r+t.character,n),r)},Object.defineProperty(e.prototype,"lineCount",{get:function(){return this.getLineOffsets().length},enumerable:!1,configurable:!0}),e}(),s;(function(e){var t=Object.prototype.toString;function i(g){return typeof g!="undefined"}e.defined=i;function r(g){return typeof g=="undefined"}e.undefined=r;function n(g){return g===!0||g===!1}e.boolean=n;function a(g){return t.call(g)==="[object String]"}e.string=a;function o(g){return t.call(g)==="[object Number]"}e.number=o;function u(g,_,W){return t.call(g)==="[object Number]"&&_<=g&&g<=W}e.numberRange=u;function c(g){return t.call(g)==="[object Number]"&&-2147483648<=g&&g<=2147483647}e.integer=c;function m(g){return t.call(g)==="[object Number]"&&0<=g&&g<=2147483647}e.uinteger=m;function p(g){return t.call(g)==="[object Function]"}e.func=p;function f(g){return g!==null&&typeof g=="object"}e.objectLiteral=f;function w(g,_){return Array.isArray(g)&&g.every(_)}e.typedArray=w})(s||(s={}));var ge=class{constructor(t,i,r){this._languageId=t;this._worker=i;this._disposables=[];this._listener=Object.create(null);let n=o=>{let u=o.getLanguageId();if(u!==this._languageId)return;let c;this._listener[o.uri.toString()]=o.onDidChangeContent(()=>{window.clearTimeout(c),c=window.setTimeout(()=>this._doValidate(o.uri,u),500)}),this._doValidate(o.uri,u)},a=o=>{l.editor.setModelMarkers(o,this._languageId,[]);let u=o.uri.toString(),c=this._listener[u];c&&(c.dispose(),delete this._listener[u])};this._disposables.push(l.editor.onDidCreateModel(n)),this._disposables.push(l.editor.onWillDisposeModel(a)),this._disposables.push(l.editor.onDidChangeModelLanguage(o=>{a(o.model),n(o.model)})),this._disposables.push(r(o=>{l.editor.getModels().forEach(u=>{u.getLanguageId()===this._languageId&&(a(u),n(u))})})),this._disposables.push({dispose:()=>{l.editor.getModels().forEach(a);for(let o in this._listener)this._listener[o].dispose()}}),l.editor.getModels().forEach(n)}dispose(){this._disposables.forEach(t=>t&&t.dispose()),this._disposables.length=0}_doValidate(t,i){this._worker(t).then(r=>r.doValidation(t.toString())).then(r=>{let n=r.map(o=>_n(t,o)),a=l.editor.getModel(t);a&&a.getLanguageId()===i&&l.editor.setModelMarkers(a,i,n)}).then(void 0,r=>{console.error(r)})}};function xn(e){switch(e){case O.Error:return l.MarkerSeverity.Error;case O.Warning:return l.MarkerSeverity.Warning;case O.Information:return l.MarkerSeverity.Info;case O.Hint:return l.MarkerSeverity.Hint;default:return l.MarkerSeverity.Info}}function _n(e,t){let i=typeof t.code=="number"?String(t.code):t.code;return{severity:xn(t.severity),startLineNumber:t.range.start.line+1,startColumn:t.range.start.character+1,endLineNumber:t.range.end.line+1,endColumn:t.range.end.character+1,message:t.message,code:i,source:t.source}}var pe=class{constructor(t,i){this._worker=t;this._triggerCharacters=i}get triggerCharacters(){return this._triggerCharacters}provideCompletionItems(t,i,r,n){let a=t.uri;return this._worker(a).then(o=>o.doComplete(a.toString(),he(i))).then(o=>{if(!o)return;let u=t.getWordUntilPosition(i),c=new l.Range(i.lineNumber,u.startColumn,i.lineNumber,u.endColumn),m=o.items.map(p=>{let f={label:p.label,insertText:p.insertText||p.label,sortText:p.sortText,filterText:p.filterText,documentation:p.documentation,detail:p.detail,command:Ln(p.command),range:c,kind:Pn(p.kind)};return p.textEdit&&(An(p.textEdit)?f.range={insert:P(p.textEdit.insert),replace:P(p.textEdit.replace)}:f.range=P(p.textEdit.range),f.insertText=p.textEdit.newText),p.additionalTextEdits&&(f.additionalTextEdits=p.additionalTextEdits.map(J)),p.insertTextFormat===ee.Snippet&&(f.insertTextRules=l.languages.CompletionItemInsertTextRule.InsertAsSnippet),f});return{isIncomplete:o.isIncomplete,suggestions:m}})}};function he(e){if(!!e)return{character:e.column-1,line:e.lineNumber-1}}function tn(e){if(!!e)return{start:{line:e.startLineNumber-1,character:e.startColumn-1},end:{line:e.endLineNumber-1,character:e.endColumn-1}}}function P(e){if(!!e)return new l.Range(e.start.line+1,e.start.character+1,e.end.line+1,e.end.character+1)}function An(e){return typeof e.insert!="undefined"&&typeof e.replace!="undefined"}function Pn(e){let t=l.languages.CompletionItemKind;switch(e){case v.Text:return t.Text;case v.Method:return t.Method;case v.Function:return t.Function;case v.Constructor:return t.Constructor;case v.Field:return t.Field;case v.Variable:return t.Variable;case v.Class:return t.Class;case v.Interface:return t.Interface;case v.Module:return t.Module;case v.Property:return t.Property;case v.Unit:return t.Unit;case v.Value:return t.Value;case v.Enum:return t.Enum;case v.Keyword:return t.Keyword;case v.Snippet:return t.Snippet;case v.Color:return t.Color;case v.File:return t.File;case v.Reference:return t.Reference}return t.Property}function J(e){if(!!e)return{range:P(e.range),text:e.newText}}function Ln(e){return e&&e.command==="editor.action.triggerSuggest"?{id:e.command,title:e.title,arguments:e.arguments}:void 0}var me=class{constructor(t){this._worker=t}provideHover(t,i,r){let n=t.uri;return this._worker(n).then(a=>a.doHover(n.toString(),he(i))).then(a=>{if(!!a)return{range:P(a.range),contents:Rn(a.contents)}})}};function Sn(e){return e&&typeof e=="object"&&typeof e.kind=="string"}function an(e){return typeof e=="string"?{value:e}:Sn(e)?e.kind==="plaintext"?{value:e.value.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")}:{value:e.value}:{value:"```"+e.language+`
`+e.value+"\n```\n"}}function Rn(e){if(!!e)return Array.isArray(e)?e.map(an):[an(e)]}var ve=class{constructor(t){this._worker=t}provideDocumentSymbols(t,i){let r=t.uri;return this._worker(r).then(n=>n.findDocumentSymbols(r.toString())).then(n=>{if(!!n)return n.map(a=>({name:a.name,detail:"",containerName:a.containerName,kind:On(a.kind),range:P(a.location.range),selectionRange:P(a.location.range),tags:[]}))})}};function On(e){let t=l.languages.SymbolKind;switch(e){case k.File:return t.Array;case k.Module:return t.Module;case k.Namespace:return t.Namespace;case k.Package:return t.Package;case k.Class:return t.Class;case k.Method:return t.Method;case k.Property:return t.Property;case k.Field:return t.Field;case k.Constructor:return t.Constructor;case k.Enum:return t.Enum;case k.Interface:return t.Interface;case k.Function:return t.Function;case k.Variable:return t.Variable;case k.Constant:return t.Constant;case k.String:return t.String;case k.Number:return t.Number;case k.Boolean:return t.Boolean;case k.Array:return t.Array}return t.Function}var ke=class{constructor(t){this._worker=t}provideDocumentFormattingEdits(t,i,r){let n=t.uri;return this._worker(n).then(a=>a.format(n.toString(),null,on(i)).then(o=>{if(!(!o||o.length===0))return o.map(J)}))}},ye=class{constructor(t){this._worker=t}provideDocumentRangeFormattingEdits(t,i,r,n){let a=t.uri;return this._worker(a).then(o=>o.format(a.toString(),tn(i),on(r)).then(u=>{if(!(!u||u.length===0))return u.map(J)}))}};function on(e){return{tabSize:e.tabSize,insertSpaces:e.insertSpaces}}var Te=class{constructor(t){this._worker=t}provideDocumentColors(t,i){let r=t.uri;return this._worker(r).then(n=>n.findDocumentColors(r.toString())).then(n=>{if(!!n)return n.map(a=>({color:a.color,range:P(a.range)}))})}provideColorPresentations(t,i,r){let n=t.uri;return this._worker(n).then(a=>a.getColorPresentations(n.toString(),i.color,tn(i.range))).then(a=>{if(!!a)return a.map(o=>{let u={label:o.label};return o.textEdit&&(u.textEdit=J(o.textEdit)),o.additionalTextEdits&&(u.additionalTextEdits=o.additionalTextEdits.map(J)),u})})}},be=class{constructor(t){this._worker=t}provideFoldingRanges(t,i,r){let n=t.uri;return this._worker(n).then(a=>a.getFoldingRanges(n.toString(),i)).then(a=>{if(!!a)return a.map(o=>{let u={start:o.startLine+1,end:o.endLine+1};return typeof o.kind!="undefined"&&(u.kind=Wn(o.kind)),u})})}};function Wn(e){switch(e){case D.Comment:return l.languages.FoldingRangeKind.Comment;case D.Imports:return l.languages.FoldingRangeKind.Imports;case D.Region:return l.languages.FoldingRangeKind.Region}}var Ce=class{constructor(t){this._worker=t}provideSelectionRanges(t,i,r){let n=t.uri;return this._worker(n).then(a=>a.getSelectionRanges(n.toString(),i.map(he))).then(a=>{if(!!a)return a.map(o=>{let u=[];for(;o;)u.push({range:P(o.range)}),o=o.parent;return u})})}};"use strict";function re(e,t){t===void 0&&(t=!1);var i=e.length,r=0,n="",a=0,o=16,u=0,c=0,m=0,p=0,f=0;function w(d,I){for(var x=0,E=0;x<d||!I;){var T=e.charCodeAt(r);if(T>=48&&T<=57)E=E*16+T-48;else if(T>=65&&T<=70)E=E*16+T-65+10;else if(T>=97&&T<=102)E=E*16+T-97+10;else break;r++,x++}return x<d&&(E=-1),E}function g(d){r=d,n="",a=0,o=16,f=0}function _(){var d=r;if(e.charCodeAt(r)===48)r++;else for(r++;r<e.length&&F(e.charCodeAt(r));)r++;if(r<e.length&&e.charCodeAt(r)===46)if(r++,r<e.length&&F(e.charCodeAt(r)))for(r++;r<e.length&&F(e.charCodeAt(r));)r++;else return f=3,e.substring(d,r);var I=r;if(r<e.length&&(e.charCodeAt(r)===69||e.charCodeAt(r)===101))if(r++,(r<e.length&&e.charCodeAt(r)===43||e.charCodeAt(r)===45)&&r++,r<e.length&&F(e.charCodeAt(r))){for(r++;r<e.length&&F(e.charCodeAt(r));)r++;I=r}else f=3;return e.substring(d,I)}function W(){for(var d="",I=r;;){if(r>=i){d+=e.substring(I,r),f=2;break}var x=e.charCodeAt(r);if(x===34){d+=e.substring(I,r),r++;break}if(x===92){if(d+=e.substring(I,r),r++,r>=i){f=2;break}var E=e.charCodeAt(r++);switch(E){case 34:d+='"';break;case 92:d+="\\";break;case 47:d+="/";break;case 98:d+="\b";break;case 102:d+="\f";break;case 110:d+=`
`;break;case 114:d+="\r";break;case 116:d+="	";break;case 117:var T=w(4,!0);T>=0?d+=String.fromCharCode(T):f=4;break;default:f=5}I=r;continue}if(x>=0&&x<=31)if(q(x)){d+=e.substring(I,r),f=2;break}else f=6;r++}return d}function U(){if(n="",f=0,a=r,c=u,p=m,r>=i)return a=i,o=17;var d=e.charCodeAt(r);if(we(d)){do r++,n+=String.fromCharCode(d),d=e.charCodeAt(r);while(we(d));return o=15}if(q(d))return r++,n+=String.fromCharCode(d),d===13&&e.charCodeAt(r)===10&&(r++,n+=`
`),u++,m=r,o=14;switch(d){case 123:return r++,o=1;case 125:return r++,o=2;case 91:return r++,o=3;case 93:return r++,o=4;case 58:return r++,o=6;case 44:return r++,o=5;case 34:return r++,n=W(),o=10;case 47:var I=r-1;if(e.charCodeAt(r+1)===47){for(r+=2;r<i&&!q(e.charCodeAt(r));)r++;return n=e.substring(I,r),o=12}if(e.charCodeAt(r+1)===42){r+=2;for(var x=i-1,E=!1;r<x;){var T=e.charCodeAt(r);if(T===42&&e.charCodeAt(r+1)===47){r+=2,E=!0;break}r++,q(T)&&(T===13&&e.charCodeAt(r)===10&&r++,u++,m=r)}return E||(r++,f=1),n=e.substring(I,r),o=13}return n+=String.fromCharCode(d),r++,o=16;case 45:if(n+=String.fromCharCode(d),r++,r===i||!F(e.charCodeAt(r)))return o=16;case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:return n+=_(),o=11;default:for(;r<i&&h(d);)r++,d=e.charCodeAt(r);if(a!==r){switch(n=e.substring(a,r),n){case"true":return o=8;case"false":return o=9;case"null":return o=7}return o=16}return n+=String.fromCharCode(d),r++,o=16}}function h(d){if(we(d)||q(d))return!1;switch(d){case 125:case 93:case 123:case 91:case 34:case 58:case 44:case 47:return!1}return!0}function hn(){var d;do d=U();while(d>=12&&d<=15);return d}return{setPosition:g,getPosition:function(){return r},scan:t?hn:U,getToken:function(){return o},getTokenValue:function(){return n},getTokenOffset:function(){return a},getTokenLength:function(){return r-a},getTokenStartLine:function(){return c},getTokenStartCharacter:function(){return a-p},getTokenError:function(){return f}}}function we(e){return e===32||e===9||e===11||e===12||e===160||e===5760||e>=8192&&e<=8203||e===8239||e===8287||e===12288||e===65279}function q(e){return e===10||e===13||e===8232||e===8233}function F(e){return e>=48&&e<=57}"use strict";"use strict";var sn;(function(e){e.DEFAULT={allowTrailingComma:!1}})(sn||(sn={}));"use strict";"use strict";var un=re;function cn(e){return{getInitialState:()=>new j(null,null,!1,null),tokenize:(t,i)=>qn(e,t,i)}}var ln="delimiter.bracket.json",fn="delimiter.array.json",Mn="delimiter.colon.json",jn="delimiter.comma.json",Un="keyword.json",Vn="keyword.json",Hn="string.value.json",Kn="number.json",zn="string.key.json",Bn="comment.block.json",Jn="comment.line.json",M;(function(i){i[i.Object=0]="Object",i[i.Array=1]="Array"})(M||(M={}));var R=class{constructor(t,i){this.parent=t;this.type=i}static pop(t){return t?t.parent:null}static push(t,i){return new R(t,i)}static equals(t,i){if(!t&&!i)return!0;if(!t||!i)return!1;for(;t&&i;){if(t===i)return!0;if(t.type!==i.type)return!1;t=t.parent,i=i.parent}return!0}},j=class{constructor(t,i,r,n){this._state=t,this.scanError=i,this.lastWasColon=r,this.parents=n}clone(){return new j(this._state,this.scanError,this.lastWasColon,this.parents)}equals(t){return t===this?!0:!t||!(t instanceof j)?!1:this.scanError===t.scanError&&this.lastWasColon===t.lastWasColon&&R.equals(this.parents,t.parents)}getStateData(){return this._state}setStateData(t){this._state=t}},te;(function(u){u[u.None=0]="None",u[u.UnexpectedEndOfComment=1]="UnexpectedEndOfComment",u[u.UnexpectedEndOfString=2]="UnexpectedEndOfString",u[u.UnexpectedEndOfNumber=3]="UnexpectedEndOfNumber",u[u.InvalidUnicode=4]="InvalidUnicode",u[u.InvalidEscapeCharacter=5]="InvalidEscapeCharacter",u[u.InvalidCharacter=6]="InvalidCharacter"})(te||(te={}));var C;(function(h){h[h.OpenBraceToken=1]="OpenBraceToken",h[h.CloseBraceToken=2]="CloseBraceToken",h[h.OpenBracketToken=3]="OpenBracketToken",h[h.CloseBracketToken=4]="CloseBracketToken",h[h.CommaToken=5]="CommaToken",h[h.ColonToken=6]="ColonToken",h[h.NullKeyword=7]="NullKeyword",h[h.TrueKeyword=8]="TrueKeyword",h[h.FalseKeyword=9]="FalseKeyword",h[h.StringLiteral=10]="StringLiteral",h[h.NumericLiteral=11]="NumericLiteral",h[h.LineCommentTrivia=12]="LineCommentTrivia",h[h.BlockCommentTrivia=13]="BlockCommentTrivia",h[h.LineBreakTrivia=14]="LineBreakTrivia",h[h.Trivia=15]="Trivia",h[h.Unknown=16]="Unknown",h[h.EOF=17]="EOF"})(C||(C={}));function qn(e,t,i,r=0){let n=0,a=!1;switch(i.scanError){case 2:t='"'+t,n=1;break;case 1:t="/*"+t,n=2;break}let o=un(t),u=i.lastWasColon,c=i.parents,m={tokens:[],endState:i.clone()};for(;;){let p=r+o.getPosition(),f="",w=o.scan();if(w===17)break;if(p===r+o.getPosition())throw new Error("Scanner did not advance, next 3 characters are: "+t.substr(o.getPosition(),3));switch(a&&(p-=n),a=n>0,w){case 1:c=R.push(c,0),f=ln,u=!1;break;case 2:c=R.pop(c),f=ln,u=!1;break;case 3:c=R.push(c,1),f=fn,u=!1;break;case 4:c=R.pop(c),f=fn,u=!1;break;case 6:f=Mn,u=!0;break;case 5:f=jn,u=!1;break;case 8:case 9:f=Un,u=!1;break;case 7:f=Vn,u=!1;break;case 10:let _=(c?c.type:0)===1;f=u||_?Hn:zn,u=!1;break;case 11:f=Kn,u=!1;break}if(e)switch(w){case 12:f=Jn;break;case 13:f=Bn;break}m.endState=new j(i.getStateData(),o.getTokenError(),u,c),m.tokens.push({startIndex:p,scopes:f})}return m}var dn=class extends ge{constructor(t,i,r){super(t,i,r.onDidChange);this._disposables.push(l.editor.onWillDisposeModel(n=>{this._resetSchema(n.uri)})),this._disposables.push(l.editor.onDidChangeModelLanguage(n=>{this._resetSchema(n.model.uri)}))}_resetSchema(t){this._worker().then(i=>{i.resetSchema(t.toString())})}};function Xn(e){let t=[],i=[],r=new oe(e);t.push(r);let n=(...u)=>r.getLanguageServiceWorker(...u);function a(){let{languageId:u,modeConfiguration:c}=e;pn(i),c.documentFormattingEdits&&i.push(l.languages.registerDocumentFormattingEditProvider(u,new ke(n))),c.documentRangeFormattingEdits&&i.push(l.languages.registerDocumentRangeFormattingEditProvider(u,new ye(n))),c.completionItems&&i.push(l.languages.registerCompletionItemProvider(u,new pe(n,[" ",":",'"']))),c.hovers&&i.push(l.languages.registerHoverProvider(u,new me(n))),c.documentSymbols&&i.push(l.languages.registerDocumentSymbolProvider(u,new ve(n))),c.tokens&&i.push(l.languages.setTokensProvider(u,cn(!0))),c.colors&&i.push(l.languages.registerColorProvider(u,new Te(n))),c.foldingRanges&&i.push(l.languages.registerFoldingRangeProvider(u,new be(n))),c.diagnostics&&i.push(new dn(u,n,e)),c.selectionRanges&&i.push(l.languages.registerSelectionRangeProvider(u,new Ce(n)))}a(),t.push(l.languages.setLanguageConfiguration(e.languageId,Yn));let o=e.modeConfiguration;return e.onDidChange(u=>{u.modeConfiguration!==o&&(o=u.modeConfiguration,a())}),t.push(gn(i)),gn(t)}function gn(e){return{dispose:()=>pn(e)}}function pn(e){for(;e.length;)e.pop().dispose()}var Yn={wordPattern:/(-?\d*\.\d\w*)|([^\[\{\]\}\:\"\,\s]+)/g,comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"]],autoClosingPairs:[{open:"{",close:"}",notIn:["string"]},{open:"[",close:"]",notIn:["string"]},{open:'"',close:'"',notIn:["string"]}]};return $n;})();
return moduleExports;
});
