/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.table;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class SavepointConnectorOptions {
    public static final String FIELDS = "fields";
    public static final String STATE_NAME = "state-name";
    public static final String STATE_TYPE = "state-type";
    public static final String DEPRECATED_MAP_KEY_FORMAT = "map-key-format";
    public static final String KEY_CLASS = "key-class";
    public static final String DEPRECATED_VALUE_FORMAT = "value-format";
    public static final String VALUE_CLASS = "value-class";
    public static final String KEY_TYPE_FACTORY = "key-type-factory";
    public static final String VALUE_TYPE_FACTORY = "value-type-factory";
    public static final ConfigOption<String> STATE_BACKEND_TYPE = ConfigOptions.key((String)"state.backend.type").stringType().noDefaultValue().withDescription(Description.builder().text("The state backend to be used to read state.").linebreak().text("The implementation can be specified either via their shortcut  name, or via the class name of a %s. If a factory is specified it is instantiated via its zero argument constructor and its %s method is called.", new InlineElement[]{TextElement.code((String)"StateBackendFactory"), TextElement.code((String)"StateBackendFactory#createFromConfig(ReadableConfig, ClassLoader)")}).linebreak().text("Recognized shortcut names are 'hashmap', 'rocksdb' and 'forst'.").build());
    public static final ConfigOption<String> STATE_PATH = ConfigOptions.key((String)"state.path").stringType().noDefaultValue().withDescription("Defines the state path which must be used for state reading.");
    public static final ConfigOption<String> OPERATOR_UID = ConfigOptions.key((String)"operator.uid").stringType().noDefaultValue().withDescription("Defines the operator UID which must be used for state reading (Can't be used together with UID hash).");
    public static final ConfigOption<String> OPERATOR_UID_HASH = ConfigOptions.key((String)"operator.uid.hash").stringType().noDefaultValue().withDescription("Defines the operator UID hash which must be used for state reading (Can't be used together with UID).");
    public static final ConfigOption<String> STATE_NAME_PLACEHOLDER = ConfigOptions.key((String)String.format("%s.#.%s", "fields", "state-name")).stringType().noDefaultValue().withDescription("Defines the state name which must be used for state reading.");
    public static final ConfigOption<StateType> STATE_TYPE_PLACEHOLDER = ConfigOptions.key((String)String.format("%s.#.%s", "fields", "state-type")).enumType(StateType.class).noDefaultValue().withDescription(Description.builder().text("Defines the state type which must be used for state reading, including %s, %s and %s. When it's not provided then it tries to be inferred from the SQL type (ARRAY=list, MAP=map, all others=value).", new InlineElement[]{TextElement.code((String)StateType.VALUE.toString()), TextElement.code((String)StateType.LIST.toString()), TextElement.code((String)StateType.MAP.toString())}).build());
    public static final ConfigOption<String> KEY_CLASS_PLACEHOLDER = ConfigOptions.key((String)String.format("%s.#.%s", "fields", "key-class")).stringType().noDefaultValue().withDeprecatedKeys(new String[]{String.format("%s.#.%s", "fields", "map-key-format")}).withDescription("Defines the format class scheme for decoding map key data. When it's not provided then it tries to be inferred from the SQL type (only primitive types supported).");
    public static final ConfigOption<String> KEY_TYPE_INFO_FACTORY_PLACEHOLDER = ConfigOptions.key((String)String.format("%s.#.%s", "fields", "key-type-factory")).stringType().noDefaultValue().withDescription(Description.builder().text("Defines the type information factory for decoding map key data. Either %s or %s can be specified. When none of them are provided then the format class scheme tries to be inferred from the SQL type (only primitive types supported).", new InlineElement[]{TextElement.code((String)"key-class"), TextElement.code((String)"key-type-factory")}).build());
    public static final ConfigOption<String> VALUE_CLASS_PLACEHOLDER = ConfigOptions.key((String)String.format("%s.#.%s", "fields", "value-class")).stringType().noDefaultValue().withDeprecatedKeys(new String[]{String.format("%s.#.%s", "fields", "value-format")}).withDescription(Description.builder().text("Defines the format class scheme for decoding value data. Either %s or %s can be specified. When none of them are provided then format class scheme tries to be inferred from the SQL type (only primitive types supported).", new InlineElement[]{TextElement.code((String)"value-class"), TextElement.code((String)"value-type-factory")}).build());
    public static final ConfigOption<String> VALUE_TYPE_INFO_FACTORY_PLACEHOLDER = ConfigOptions.key((String)String.format("%s.#.%s", "fields", "value-type-factory")).stringType().noDefaultValue().withDescription(Description.builder().text("Defines the type information factory for decoding value data. Either %s or %s can be specified. When none of them are provided then the format class scheme tries to be inferred from the SQL type (only primitive types supported).", new InlineElement[]{TextElement.code((String)"value-class"), TextElement.code((String)"value-type-factory")}).build());

    private SavepointConnectorOptions() {
    }

    public static enum StateType {
        VALUE,
        LIST,
        MAP;

    }
}

