/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.common.hadoop;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.CommitterFromPersistRecoverableFsDataOutputStream;
import org.apache.flink.fs.azure.common.hadoop.HadoopFsRecoverable;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

@Internal
public abstract class BaseHadoopFsRecoverableFsDataOutputStream
extends CommitterFromPersistRecoverableFsDataOutputStream<HadoopFsRecoverable> {
    protected FileSystem fs;
    protected Path targetFile;
    protected Path tempFile;
    protected FSDataOutputStream out;
    protected long initialFileSize = 0L;

    public long getPos() throws IOException {
        return this.out.getPos();
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void flush() throws IOException {
        this.out.hflush();
    }

    public void sync() throws IOException {
        this.out.hflush();
        this.out.hsync();
    }

    public HadoopFsRecoverable persist() throws IOException {
        this.sync();
        return this.createHadoopFsRecoverable(this.getPos());
    }

    public HadoopFsRecoverable createHadoopFsRecoverable(long pos) {
        return new HadoopFsRecoverable(this.targetFile, this.tempFile, pos + this.initialFileSize);
    }

    public void close() throws IOException {
        this.out.close();
    }
}

