/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs.utils;

import java.net.URI;
import java.util.UUID;
import org.apache.flink.fs.gs.GSFileSystemOptions;
import org.apache.flink.fs.gs.storage.GSBlobIdentifier;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class BlobUtils {
    private static final String TEMPORARY_OBJECT_PREFIX = ".inprogress";
    public static final int COMPOSE_MAX_BLOBS = 32;

    public static GSBlobIdentifier parseUri(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals("gs"), (Object)String.format("URI scheme for %s must be %s", uri, "gs"));
        String finalBucketName = uri.getAuthority();
        if (StringUtils.isNullOrWhitespaceOnly((String)finalBucketName)) {
            throw new IllegalArgumentException(String.format("Bucket name in %s is invalid", uri));
        }
        String path = uri.getPath();
        if (StringUtils.isNullOrWhitespaceOnly((String)path)) {
            throw new IllegalArgumentException(String.format("Object name in %s is invalid", uri));
        }
        String finalObjectName = path.substring(1);
        if (StringUtils.isNullOrWhitespaceOnly((String)finalObjectName)) {
            throw new IllegalArgumentException(String.format("Object name in %s is invalid", uri));
        }
        return new GSBlobIdentifier(finalBucketName, finalObjectName);
    }

    public static String getTemporaryBucketName(GSBlobIdentifier finalBlobIdentifier, GSFileSystemOptions options) {
        return options.getWriterTemporaryBucketName().orElse(finalBlobIdentifier.bucketName);
    }

    public static String getTemporaryObjectPartialName(GSBlobIdentifier finalBlobIdentifier) {
        return String.format("%s/%s/%s/", TEMPORARY_OBJECT_PREFIX, finalBlobIdentifier.bucketName, finalBlobIdentifier.objectName);
    }

    public static String getTemporaryObjectName(GSBlobIdentifier finalBlobIdentifier, UUID temporaryObjectId) {
        return BlobUtils.getTemporaryObjectPartialName(finalBlobIdentifier) + temporaryObjectId.toString();
    }

    public static String getTemporaryObjectNameWithEntropy(GSBlobIdentifier finalBlobIdentifier, UUID temporaryObjectId) {
        return temporaryObjectId.toString() + BlobUtils.getTemporaryObjectPartialName(finalBlobIdentifier) + temporaryObjectId.toString();
    }

    public static GSBlobIdentifier getTemporaryBlobIdentifier(GSBlobIdentifier finalBlobIdentifier, UUID temporaryObjectId, GSFileSystemOptions options) {
        String temporaryBucketName = BlobUtils.getTemporaryBucketName(finalBlobIdentifier, options);
        String temporaryObjectName = options.isFileSinkEntropyEnabled() != false ? BlobUtils.getTemporaryObjectNameWithEntropy(finalBlobIdentifier, temporaryObjectId) : BlobUtils.getTemporaryObjectName(finalBlobIdentifier, temporaryObjectId);
        return new GSBlobIdentifier(temporaryBucketName, temporaryObjectName);
    }
}

