/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.exemplar.util;

import io.opencensus.contrib.exemplar.util.AttachmentValueSpanContext;
import io.opencensus.stats.MeasureMap;
import io.opencensus.trace.SpanContext;
import javax.annotation.Nullable;

public final class ExemplarUtils {
    public static final String ATTACHMENT_KEY_SPAN_CONTEXT = "SpanContext";

    public static void putSpanContextAttachments(MeasureMap measureMap, SpanContext spanContext) {
        ExemplarUtils.checkNotNull(measureMap, "measureMap");
        ExemplarUtils.checkNotNull(spanContext, "spanContext");
        measureMap.putAttachment(ATTACHMENT_KEY_SPAN_CONTEXT, AttachmentValueSpanContext.create(spanContext));
    }

    private static <T> T checkNotNull(T reference, @Nullable Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    private ExemplarUtils() {
    }
}

