/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.bundle.trigger.CoBundleTrigger;
import org.apache.flink.table.runtime.operators.bundle.trigger.CountBundleTrigger;
import org.apache.flink.table.runtime.operators.bundle.trigger.CountCoBundleTrigger;

public class MinibatchUtil {
    public static boolean isMiniBatchEnabled(ReadableConfig config) {
        return (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED);
    }

    public static CountBundleTrigger<RowData> createMiniBatchTrigger(ReadableConfig config) {
        long size = MinibatchUtil.miniBatchSize(config);
        return new CountBundleTrigger(size);
    }

    public static CoBundleTrigger<RowData, RowData> createMiniBatchCoTrigger(ReadableConfig config) {
        long size = MinibatchUtil.miniBatchSize(config);
        return new CountCoBundleTrigger(size);
    }

    public static long miniBatchSize(ReadableConfig config) {
        long size = (Long)config.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE);
        if (size <= 0L) {
            throw new IllegalArgumentException(String.valueOf(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE) + " must be > 0.");
        }
        return size;
    }
}

