/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.annotation.Internal;
import org.apache.flink.legacy.table.sinks.RetractStreamTableSink;
import org.apache.flink.legacy.table.sinks.StreamTableSink;
import org.apache.flink.legacy.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.legacy.sinks.TableSink;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalCalcBase;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDataStreamScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDropUpdateBefore;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalExchange;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalIntermediateTableScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLegacySink;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalMiniBatchAssigner;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalSink;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalWatermarkAssigner;
import org.apache.flink.table.planner.plan.rules.physical.stream.ImmutableDuplicateChangesInferRule;
import org.apache.flink.table.planner.plan.trait.DuplicateChanges;
import org.apache.flink.table.planner.plan.trait.DuplicateChangesTrait;
import org.apache.flink.table.planner.plan.trait.DuplicateChangesTraitDef;
import org.apache.flink.table.planner.plan.utils.DuplicateChangesUtils;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import org.apache.flink.table.planner.sinks.DataStreamTableSink;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.immutables.value.Value;

@Internal
@Value.Enclosing
public class DuplicateChangesInferRule
extends RelRule<Config> {
    public static final DuplicateChangesInferRule INSTANCE = Config.DEFAULT.toRule();

    protected DuplicateChangesInferRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        DuplicateChangesTrait requiredTrait;
        StreamPhysicalRel rel = (StreamPhysicalRel)call.rel(0);
        DuplicateChangesTrait parentTrait = rel.getTraitSet().getTrait(DuplicateChangesTraitDef.INSTANCE);
        Preconditions.checkState((parentTrait != null ? 1 : 0) != 0);
        if (rel instanceof StreamPhysicalSink) {
            boolean canConsumeDuplicateChanges = this.canConsumeDuplicateChanges((StreamPhysicalSink)rel);
            boolean isMaterialized = ((StreamPhysicalSink)rel).upsertMaterialize();
            requiredTrait = canConsumeDuplicateChanges && !isMaterialized ? DuplicateChangesTrait.ALLOW : DuplicateChangesTrait.DISALLOW;
        } else {
            RexProgram calcProgram;
            boolean canConsumeDuplicateChanges;
            requiredTrait = rel instanceof StreamPhysicalLegacySink ? ((canConsumeDuplicateChanges = this.canConsumeDuplicateChanges((StreamPhysicalLegacySink)rel)) ? DuplicateChangesTrait.ALLOW : DuplicateChangesTrait.DISALLOW) : (rel instanceof StreamPhysicalCalcBase ? (!FlinkRexUtil.isDeterministic(calcProgram = ((StreamPhysicalCalcBase)rel).getProgram()) ? DuplicateChangesTrait.DISALLOW : parentTrait) : (rel instanceof StreamPhysicalExchange || rel instanceof StreamPhysicalMiniBatchAssigner || rel instanceof StreamPhysicalWatermarkAssigner || rel instanceof StreamPhysicalDropUpdateBefore || rel instanceof StreamPhysicalTableSourceScan || rel instanceof StreamPhysicalDataStreamScan || rel instanceof StreamPhysicalLegacyTableSourceScan || rel instanceof StreamPhysicalIntermediateTableScan ? parentTrait : DuplicateChangesTrait.DISALLOW));
        }
        boolean anyInputUpdated = false;
        List<RelNode> inputs = this.getInputs(rel);
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        for (RelNode input : inputs) {
            DuplicateChangesTrait inputOriginalTrait = input.getTraitSet().getTrait(DuplicateChangesTraitDef.INSTANCE);
            if (!requiredTrait.equals(inputOriginalTrait)) {
                DuplicateChangesTrait mergedTrait = DuplicateChangesInferRule.mergeDuplicateChangesTrait(inputOriginalTrait, requiredTrait);
                RelNode newInput = input.copy(input.getTraitSet().plus(mergedTrait), input.getInputs());
                newInputs.add(newInput);
                anyInputUpdated = true;
                continue;
            }
            newInputs.add(input);
        }
        if (anyInputUpdated) {
            RelNode newRel = rel.copy(rel.getTraitSet(), newInputs);
            call.transformTo(newRel);
        }
    }

    private static DuplicateChangesTrait mergeDuplicateChangesTrait(DuplicateChangesTrait inputOriginalTrait, DuplicateChangesTrait newRequiredTrait) {
        DuplicateChangesTrait mergedTrait;
        if (inputOriginalTrait == null) {
            mergedTrait = newRequiredTrait;
        } else {
            DuplicateChanges mergedDuplicateChanges = DuplicateChangesUtils.mergeDuplicateChanges(inputOriginalTrait.getDuplicateChanges(), newRequiredTrait.getDuplicateChanges());
            mergedTrait = new DuplicateChangesTrait(mergedDuplicateChanges);
        }
        return mergedTrait;
    }

    private boolean canConsumeDuplicateChanges(StreamPhysicalSink sink) {
        boolean acceptUpdates = true;
        try {
            ChangelogMode sinkProvidedChangelogMode = sink.tableSink().getChangelogMode(ChangelogMode.all());
            boolean sinkIsAppend = sinkProvidedChangelogMode.containsOnly(RowKind.INSERT);
            boolean sinkIsRetract = sinkProvidedChangelogMode.contains(RowKind.UPDATE_BEFORE);
            if (sinkIsAppend || sinkIsRetract) {
                acceptUpdates = false;
            }
        }
        catch (Throwable t) {
            acceptUpdates = false;
        }
        return acceptUpdates && sink.contextResolvedTable().getResolvedSchema().getPrimaryKey().isPresent();
    }

    private boolean canConsumeDuplicateChanges(StreamPhysicalLegacySink<?> sink) {
        boolean onlyAcceptInsertOnly;
        TableSink<?> tableSink = sink.sink();
        if (tableSink instanceof UpsertStreamTableSink || tableSink instanceof RetractStreamTableSink) {
            onlyAcceptInsertOnly = false;
        } else if (tableSink instanceof StreamTableSink) {
            onlyAcceptInsertOnly = true;
        } else if (tableSink instanceof DataStreamTableSink) {
            onlyAcceptInsertOnly = !((DataStreamTableSink)tableSink).withChangeFlag();
        } else {
            throw new IllegalStateException("Unknown legacy sink type: " + sink.getClass().getSimpleName());
        }
        return !onlyAcceptInsertOnly && sink.sink().getTableSchema().getPrimaryKey().isPresent();
    }

    private List<RelNode> getInputs(RelNode parent) {
        return parent.getInputs().stream().map(rel -> {
            if (rel instanceof HepRelVertex) {
                return ((HepRelVertex)rel).getCurrentRel();
            }
            return rel;
        }).collect(Collectors.toList());
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableDuplicateChangesInferRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(StreamPhysicalRel.class).anyInputs()).withDescription("DuplicateChangesInferRule").as(Config.class);

        @Override
        default public DuplicateChangesInferRule toRule() {
            return new DuplicateChangesInferRule(this);
        }
    }
}

