/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.FlinkConvention;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalExchange;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalSort;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalExchange;
import org.apache.flink.table.planner.plan.rules.physical.FlinkExpandConversionRule;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTrait;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTraitDef$;
import org.apache.flink.table.planner.plan.trait.UpdateKindTrait;
import org.apache.flink.table.planner.plan.trait.UpdateKindTraitDef$;

public final class FlinkExpandConversionRule$ {
    public static FlinkExpandConversionRule$ MODULE$;
    private final FlinkExpandConversionRule BATCH_INSTANCE;
    private final FlinkExpandConversionRule STREAM_INSTANCE;

    static {
        new FlinkExpandConversionRule$();
    }

    public FlinkExpandConversionRule BATCH_INSTANCE() {
        return this.BATCH_INSTANCE;
    }

    public FlinkExpandConversionRule STREAM_INSTANCE() {
        return this.STREAM_INSTANCE;
    }

    public RelNode satisfyDistribution(Convention flinkConvention, RelNode node, FlinkRelDistribution requiredDistribution) {
        RelTraitSet fromTraitSet = node.getTraitSet();
        FlinkRelDistribution fromDistribution = fromTraitSet.getTrait(FlinkRelDistributionTraitDef$.MODULE$.INSTANCE());
        if (!fromDistribution.satisfies(requiredDistribution)) {
            RelDistribution.Type type = requiredDistribution.getType();
            if (((Object)((Object)RelDistribution.Type.SINGLETON)).equals((Object)type) ? true : (((Object)((Object)RelDistribution.Type.HASH_DISTRIBUTED)).equals((Object)type) ? true : (((Object)((Object)RelDistribution.Type.RANGE_DISTRIBUTED)).equals((Object)type) ? true : (((Object)((Object)RelDistribution.Type.BROADCAST_DISTRIBUTED)).equals((Object)type) ? true : ((Object)((Object)RelDistribution.Type.RANDOM_DISTRIBUTED)).equals((Object)type))))) {
                Convention convention = flinkConvention;
                FlinkConvention flinkConvention2 = FlinkConventions$.MODULE$.BATCH_PHYSICAL();
                Convention convention2 = convention;
                if (!(flinkConvention2 != null ? !flinkConvention2.equals(convention2) : convention2 != null)) {
                    RelTraitSet traitSet = fromTraitSet.replace(requiredDistribution).replace(flinkConvention).replace(RelCollations.EMPTY);
                    return new BatchPhysicalExchange(node.getCluster(), traitSet, node, requiredDistribution);
                }
                FlinkConvention flinkConvention3 = FlinkConventions$.MODULE$.STREAM_PHYSICAL();
                Convention convention3 = convention;
                if (!(flinkConvention3 != null ? !flinkConvention3.equals(convention3) : convention3 != null)) {
                    ModifyKindSetTrait modifyKindSetTrait = fromTraitSet.getTrait(ModifyKindSetTraitDef$.MODULE$.INSTANCE());
                    UpdateKindTrait updateKindTrait = fromTraitSet.getTrait(UpdateKindTraitDef$.MODULE$.INSTANCE());
                    RelTraitSet traitSet = fromTraitSet.replace(requiredDistribution).replace(flinkConvention).replace(RelCollations.EMPTY).replace(modifyKindSetTrait).replace(updateKindTrait);
                    return new StreamPhysicalExchange(node.getCluster(), traitSet, node, requiredDistribution);
                }
                throw new TableException(new StringBuilder(24).append("Unsupported convention: ").append(flinkConvention).toString());
            }
            throw new TableException(new StringBuilder(18).append("Unsupported type: ").append((Object)requiredDistribution.getType()).toString());
        }
        return node;
    }

    public RelNode satisfyCollation(Convention flinkConvention, RelNode node, RelCollation requiredCollation) {
        RelCollation fromCollation = node.getTraitSet().getTrait(RelCollationTraitDef.INSTANCE);
        if (!fromCollation.satisfies(requiredCollation)) {
            RelTraitSet traitSet = node.getTraitSet().replace(requiredCollation).replace(flinkConvention);
            RelCollation sortCollation = RelCollationTraitDef.INSTANCE.canonize(requiredCollation);
            Convention convention = flinkConvention;
            FlinkConvention flinkConvention2 = FlinkConventions$.MODULE$.BATCH_PHYSICAL();
            Convention convention2 = convention;
            if (!(flinkConvention2 != null ? !flinkConvention2.equals(convention2) : convention2 != null)) {
                return new BatchPhysicalSort(node.getCluster(), traitSet, node, sortCollation);
            }
            throw new TableException(new StringBuilder(24).append("Unsupported convention: ").append(flinkConvention).toString());
        }
        return node;
    }

    private FlinkExpandConversionRule$() {
        MODULE$ = this;
        this.BATCH_INSTANCE = new FlinkExpandConversionRule(FlinkConventions$.MODULE$.BATCH_PHYSICAL());
        this.STREAM_INSTANCE = new FlinkExpandConversionRule(FlinkConventions$.MODULE$.STREAM_PHYSICAL());
    }
}

