/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.MLPredictRuntimeConfigOptions;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.ml.AsyncPredictRuntimeProvider;
import org.apache.flink.table.ml.PredictRuntimeProvider;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.RexModelCall;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalMLPredictTableFunction;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;

public class StreamPhysicalMLPredictTableFunctionRule
extends ConverterRule {
    private static final String CONFIG_ERROR_MESSAGE = "Config parameter of ML_PREDICT function should be a MAP data type consisting String literals.";
    public static final StreamPhysicalMLPredictTableFunctionRule INSTANCE = new StreamPhysicalMLPredictTableFunctionRule(ConverterRule.Config.INSTANCE.withConversion(FlinkLogicalTableFunctionScan.class, FlinkConventions.LOGICAL(), FlinkConventions.STREAM_PHYSICAL(), "StreamPhysicalModelTableFunctionRule"));

    private StreamPhysicalMLPredictTableFunctionRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)call.rel(0);
        RexCall rexCall = (RexCall)scan.getCall();
        FunctionDefinition definition = ShortcutUtils.unwrapFunctionDefinition(rexCall);
        if (!StreamPhysicalMLPredictTableFunctionRule.isMLPredictFunction(definition)) {
            return false;
        }
        RexModelCall modelCall = (RexModelCall)rexCall.getOperands().get(1);
        return modelCall.getModelProvider() instanceof PredictRuntimeProvider || modelCall.getModelProvider() instanceof AsyncPredictRuntimeProvider;
    }

    @Override
    public @Nullable RelNode convert(RelNode rel) {
        FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)rel;
        RelNode newInput = RelOptRule.convert(scan.getInput(0), FlinkConventions.STREAM_PHYSICAL());
        RelTraitSet providedTraitSet = rel.getTraitSet().replace(FlinkConventions.STREAM_PHYSICAL());
        RexCall rexCall = (RexCall)scan.getCall();
        Map<String, String> runtimeConfig = StreamPhysicalMLPredictTableFunctionRule.buildRuntimeConfig(rexCall);
        return new StreamPhysicalMLPredictTableFunction(scan.getCluster(), providedTraitSet, newInput, scan, scan.getRowType(), runtimeConfig);
    }

    public static boolean isMLPredictFunction(FunctionDefinition definition) {
        return definition instanceof BuiltInFunctionDefinition && BuiltInFunctionDefinitions.ML_PREDICT.getName().equals(((BuiltInFunctionDefinition)definition).getName());
    }

    private static Map<String, String> buildRuntimeConfig(RexCall rexCall) {
        List<RexNode> operands = rexCall.getOperands();
        if (operands.size() < 4) {
            return Collections.emptyMap();
        }
        RexNode configOperand = operands.get(3);
        if (configOperand.getKind() == SqlKind.DEFAULT) {
            return Collections.emptyMap();
        }
        if (configOperand.getKind() != SqlKind.MAP_VALUE_CONSTRUCTOR) {
            throw new ValidationException(CONFIG_ERROR_MESSAGE);
        }
        if (!(configOperand instanceof RexCall)) {
            throw new ValidationException(CONFIG_ERROR_MESSAGE);
        }
        RexCall mapConstructorCall = (RexCall)configOperand;
        RelDataType mapType = mapConstructorCall.getType();
        if (!(mapType instanceof MapSqlType)) {
            throw new ValidationException(CONFIG_ERROR_MESSAGE);
        }
        LogicalType keyType = FlinkTypeFactory.toLogicalType(mapType.getKeyType());
        LogicalType valueType = FlinkTypeFactory.toLogicalType(mapType.getValueType());
        if (!keyType.is(LogicalTypeFamily.CHARACTER_STRING) || !valueType.is(LogicalTypeFamily.CHARACTER_STRING)) {
            throw new ValidationException(CONFIG_ERROR_MESSAGE);
        }
        Map<String, String> runtimeConfig = FunctionCallUtil.convert(mapConstructorCall);
        StreamPhysicalMLPredictTableFunctionRule.validateRuntimeConfig(runtimeConfig);
        return runtimeConfig;
    }

    private static void validateRuntimeConfig(Map<String, String> runtimeConfig) {
        Integer maxConcurrentOperations;
        Configuration config = Configuration.fromMap(runtimeConfig);
        try {
            MLPredictRuntimeConfigOptions.getSupportedOptions().forEach(arg_0 -> ((Configuration)config).get(arg_0));
        }
        catch (Throwable t) {
            throw new ValidationException("Failed to parse the config.", t);
        }
        Boolean async = (Boolean)config.get(MLPredictRuntimeConfigOptions.ASYNC);
        if (Boolean.TRUE.equals(async) && (maxConcurrentOperations = (Integer)config.get(MLPredictRuntimeConfigOptions.ASYNC_MAX_CONCURRENT_OPERATIONS)) != null && maxConcurrentOperations <= 0) {
            throw new ValidationException(String.format("Invalid runtime config option '%s'. Its value should be positive integer but was %s.", MLPredictRuntimeConfigOptions.ASYNC_MAX_CONCURRENT_OPERATIONS.key(), maxConcurrentOperations));
        }
    }
}

