/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DeltaJoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecDeltaJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;
import org.apache.flink.table.planner.plan.utils.JoinTypeUtil;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil;
import org.apache.flink.table.planner.plan.utils.UpsertKeyUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import scala.collection.immutable.List;

public class StreamPhysicalDeltaJoin
extends Join
implements StreamPhysicalRel {
    private final RelDataType rowType;
    private final DeltaJoinSpec lookupRightTableJoinSpec;
    private final DeltaJoinSpec lookupLeftTableJoinSpec;

    public StreamPhysicalDeltaJoin(RelOptCluster cluster, RelTraitSet traitSet, java.util.List<RelHint> hints, RelNode left, RelNode right, JoinRelType joinType, RexNode originalJoinCondition, DeltaJoinSpec lookupRightTableJoinSpec, DeltaJoinSpec lookupLeftTableJoinSpec, RelDataType rowType) {
        super(cluster, traitSet, hints, left, right, originalJoinCondition, Collections.emptySet(), joinType);
        this.lookupRightTableJoinSpec = lookupRightTableJoinSpec;
        this.lookupLeftTableJoinSpec = lookupLeftTableJoinSpec;
        this.rowType = rowType;
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        TableConfig config = ShortcutUtils.unwrapTableConfig(this);
        FunctionCallUtil.AsyncOptions asyncLookupOptions = new FunctionCallUtil.AsyncOptions((Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_BUFFER_CAPACITY), ((Duration)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_TIMEOUT)).toMillis(), true, AsyncDataStream.OutputMode.ORDERED);
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(this.getCluster().getMetadataQuery());
        int[] leftUpsertKey = UpsertKeyUtil.smallestKey(fmq.getUpsertKeys(this.left)).orElse(null);
        int[] rightUpsertKey = UpsertKeyUtil.smallestKey(fmq.getUpsertKeys(this.right)).orElse(null);
        return new StreamExecDeltaJoin((ReadableConfig)config, JoinTypeUtil.getFlinkJoinType(this.joinType), this.joinInfo.leftKeys.toIntArray(), leftUpsertKey, this.lookupRightTableJoinSpec, this.joinInfo.rightKeys.toIntArray(), rightUpsertKey, this.lookupLeftTableJoinSpec, InputProperty.DEFAULT, InputProperty.DEFAULT, FlinkTypeFactory.toLogicalRowType(this.rowType), this.getRelDetailedDescription(), asyncLookupOptions);
    }

    @Override
    public boolean requireWatermark() {
        return false;
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new StreamPhysicalDeltaJoin(this.getCluster(), traitSet, this.hints, left, right, joinType, conditionExpr, this.lookupRightTableJoinSpec, this.lookupLeftTableJoinSpec, this.rowType);
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.rowType;
    }

    @Override
    public ImmutableList<RelHint> getHints() {
        return this.hints;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.input("left", this.left).input("right", this.right).item("joinType", JoinTypeUtil.getFlinkJoinType(this.joinType).toString()).item("where", this.getExpressionString(this.condition, (List<String>)JavaScalaConversionUtil.toScala(this.getRowType().getFieldNames()).toList(), JavaScalaConversionUtil.toScala(Optional.empty()), RelExplainUtil.preferExpressionFormat(pw), RelExplainUtil.preferExpressionDetail(pw))).item("select", String.join((CharSequence)", ", this.rowType.getFieldNames()));
    }
}

