/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.EqualiserCodeGenerator;
import org.apache.flink.table.planner.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.planner.codegen.sort.ComparatorCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.OverSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.OverAggregateUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.over.NonTimeRangeUnboundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.NonTimeRowsUnboundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.ProcTimeRangeBoundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.ProcTimeRowsBoundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.ProcTimeUnboundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.RowTimeRangeBoundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.RowTimeRangeUnboundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.RowTimeRowsBoundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.RowTimeRowsUnboundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.RowTimeUnboundedPrecedingOverFunctionV2;
import org.apache.flink.table.runtime.operators.over.TimeAttribute;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExecNodeMetadata(name="stream-exec-over-aggregate", version=1, producedTransformations={"over-aggregate"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecOverAggregate
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamExecOverAggregate.class);
    public static final String OVER_AGGREGATE_TRANSFORMATION = "over-aggregate";
    public static final String FIELD_NAME_OVER_SPEC = "overSpec";
    public static final String FIELD_NAME_UNBOUNDED_OVER_VERSION = "unboundedOverVersion";
    @JsonProperty(value="unboundedOverVersion")
    private final int unboundedOverVersion;
    @JsonProperty(value="overSpec")
    private final OverSpec overSpec;

    public StreamExecOverAggregate(ReadableConfig tableConfig, OverSpec overSpec, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecOverAggregate.class), ExecNodeContext.newPersistedConfig(StreamExecOverAggregate.class, tableConfig), overSpec, Collections.singletonList(inputProperty), outputType, description, (Integer)tableConfig.get(ExecutionConfigOptions.UNBOUNDED_OVER_VERSION));
    }

    @JsonCreator
    public StreamExecOverAggregate(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="overSpec") OverSpec overSpec, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description, @Nullable @JsonProperty(value="unboundedOverVersion") Integer unboundedOverVersion) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.overSpec = (OverSpec)Preconditions.checkNotNull((Object)overSpec);
        if (unboundedOverVersion == null) {
            unboundedOverVersion = 1;
        }
        this.unboundedOverVersion = unboundedOverVersion;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        KeyedProcessFunction<RowData, RowData, RowData> overProcessFunction;
        if (this.overSpec.getGroups().size() > 1) {
            throw new TableException("All aggregates must be computed on the same window.");
        }
        OverSpec.GroupSpec group = this.overSpec.getGroups().get(0);
        int[] orderKeys = group.getSort().getFieldIndices();
        boolean[] isAscendingOrders = group.getSort().getAscendingOrders();
        if (orderKeys.length != 1 || isAscendingOrders.length != 1) {
            throw new TableException("The window can only be ordered by a single time column.");
        }
        if (!isAscendingOrders[0]) {
            throw new TableException("The window can only be ordered in ASCENDING mode.");
        }
        int[] partitionKeys = this.overSpec.getPartition().getFieldIndices();
        if (partitionKeys.length > 0 && config.getStateRetentionTime() < 0L) {
            LOG.warn("No state retention interval configured for a query which accumulates state. Please provide a query configuration with valid retention interval to prevent excessive state size. You may specify a retention time of 0 to not clean up the state.");
        }
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        int orderKey = orderKeys[0];
        LogicalType orderKeyType = ((RowType.RowField)inputRowType.getFields().get(orderKey)).getType();
        TimeAttribute timeAttribute = LogicalTypeChecks.isRowtimeAttribute((LogicalType)orderKeyType) ? TimeAttribute.ROW_TIME : (LogicalTypeChecks.isProctimeAttribute((LogicalType)orderKeyType) ? TimeAttribute.PROC_TIME : TimeAttribute.NON_TIME);
        List<RexLiteral> constants = this.overSpec.getConstants();
        ArrayList<CallSite> fieldNames = new ArrayList<CallSite>(inputRowType.getFieldNames());
        ArrayList<LogicalType> fieldTypes = new ArrayList<LogicalType>(inputRowType.getChildren());
        IntStream.range(0, constants.size()).forEach(i -> fieldNames.add((CallSite)((Object)("TMP" + i))));
        for (int i2 = 0; i2 < constants.size(); ++i2) {
            fieldNames.add((CallSite)((Object)("TMP" + i2)));
            fieldTypes.add(FlinkTypeFactory.toLogicalType(constants.get(i2).getType()));
        }
        RowType aggInputRowType = RowType.of((LogicalType[])fieldTypes.toArray(new LogicalType[0]), (String[])fieldNames.toArray(new String[0]));
        CodeGeneratorContext ctx = new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader());
        if (group.getLowerBound().isPreceding() && group.getLowerBound().isUnbounded() && group.getUpperBound().isCurrentRow()) {
            overProcessFunction = this.createUnboundedOverProcessFunction(ctx, group.getAggCalls(), constants, aggInputRowType, inputRowType, group.isRows(), orderKeys, timeAttribute, config, planner.createRelBuilder(), planner.getTypeFactory());
        } else if (group.getLowerBound().isPreceding() && !group.getLowerBound().isUnbounded() && group.getUpperBound().isCurrentRow()) {
            Object boundValue = OverAggregateUtil.getBoundary(this.overSpec, group.getLowerBound());
            if (boundValue instanceof BigDecimal) {
                throw new TableException("the specific value is decimal which haven not supported yet.");
            }
            long precedingOffset = -1L * (Long)boundValue + (long)(group.isRows() ? 1 : 0);
            overProcessFunction = this.createBoundedOverProcessFunction(ctx, group.getAggCalls(), constants, aggInputRowType, inputRowType, group.isRows(), orderKeys, timeAttribute, precedingOffset, config, planner.createRelBuilder(), planner.getTypeFactory());
        } else {
            throw new TableException("OVER RANGE FOLLOWING windows are not supported yet.");
        }
        KeyedProcessOperator operator = new KeyedProcessOperator(overProcessFunction);
        OneInputTransformation transform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(OVER_AGGREGATE_TRANSFORMATION, config), operator, InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism(), false);
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), partitionKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)inputRowType));
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType((TypeInformation)selector.getProducedType());
        return transform;
    }

    private KeyedProcessFunction<RowData, RowData, RowData> createUnboundedOverProcessFunction(CodeGeneratorContext ctx, List<AggregateCall> aggCalls, List<RexLiteral> constants, RowType aggInputRowType, RowType inputRowType, boolean isRowsClause, int[] orderKeys, TimeAttribute timeAttribute, ExecNodeConfig config, RelBuilder relBuilder, FlinkTypeFactory typeFactory) {
        AggregateInfoList aggInfoList = AggregateUtil.transformToStreamAggregateInfoList(typeFactory, aggInputRowType, JavaScalaConversionUtil.toScala(aggCalls), new boolean[aggCalls.size()], false, true, true);
        LogicalType[] fieldTypes = inputRowType.getChildren().toArray(new LogicalType[0]);
        AggsHandlerCodeGenerator aggsGenerator = new AggsHandlerCodeGenerator(ctx, relBuilder, JavaScalaConversionUtil.toScala(Arrays.asList(fieldTypes)), false);
        aggsGenerator = aggsGenerator.needAccumulate().withConstants(JavaScalaConversionUtil.toScala(constants));
        GeneratedAggsHandleFunction genAggsHandler = aggsGenerator.generateAggsHandler("UnboundedOverAggregateHelper", aggInfoList);
        LogicalType[] flattenAccTypes = (LogicalType[])Arrays.stream(aggInfoList.getAccTypes()).map(LogicalTypeDataTypeConverter::fromDataTypeToLogicalType).toArray(LogicalType[]::new);
        switch (timeAttribute) {
            case ROW_TIME: {
                int rowTimeIdx = orderKeys[0];
                switch (this.unboundedOverVersion) {
                    case 1: {
                        if (isRowsClause) {
                            return new RowTimeRowsUnboundedPrecedingFunction(config.getStateRetentionTime(), TableConfigUtils.getMaxIdleStateRetentionTime(config), genAggsHandler, flattenAccTypes, fieldTypes, rowTimeIdx);
                        }
                        return new RowTimeRangeUnboundedPrecedingFunction(config.getStateRetentionTime(), TableConfigUtils.getMaxIdleStateRetentionTime(config), genAggsHandler, flattenAccTypes, fieldTypes, rowTimeIdx);
                    }
                    case 2: {
                        return new RowTimeUnboundedPrecedingOverFunctionV2(isRowsClause, config.getStateRetentionTime(), TableConfigUtils.getMaxIdleStateRetentionTime(config), genAggsHandler, flattenAccTypes, fieldTypes, rowTimeIdx);
                    }
                }
                throw new UnsupportedOperationException("Unsupported unbounded over version: " + this.unboundedOverVersion + ". Valid versions are 1 and 2.");
            }
            case PROC_TIME: {
                return new ProcTimeUnboundedPrecedingFunction(StateConfigUtil.createTtlConfig((long)config.getStateRetentionTime()), genAggsHandler, flattenAccTypes);
            }
            case NON_TIME: {
                GeneratedRecordEqualiser generatedRecordEqualiser = new EqualiserCodeGenerator((LogicalType)inputRowType, ctx.classLoader()).generateRecordEqualiser("FirstMatchingRowEqualiser");
                LogicalType[] sortKeyTypes = new LogicalType[orderKeys.length];
                for (int i = 0; i < orderKeys.length; ++i) {
                    sortKeyTypes[i] = ((RowType.RowField)inputRowType.getFields().get(orderKeys[i])).getType();
                }
                RowType sortKeyRowType = RowType.of((LogicalType[])sortKeyTypes);
                GeneratedRecordEqualiser generatedSortKeyEqualiser = new EqualiserCodeGenerator((LogicalType)sortKeyRowType, ctx.classLoader()).generateRecordEqualiser("FirstMatchingSortKeyEqualiser");
                SortSpec.SortSpecBuilder builder = SortSpec.builder();
                IntStream.range(0, orderKeys.length).forEach(idx -> builder.addField(idx, this.overSpec.getGroups().get(0).getSort().getFieldSpec(idx).getIsAscendingOrder(), this.overSpec.getGroups().get(0).getSort().getFieldSpec(idx).getNullIsLast()));
                SortSpec sortSpecInSortKey = builder.build();
                GeneratedRecordComparator generatedRecordComparator = ComparatorCodeGenerator.gen(config, ctx.classLoader(), "SortComparator", sortKeyRowType, sortSpecInSortKey);
                InternalTypeInfo inputRowTypeInfo = InternalTypeInfo.of((RowType)inputRowType);
                RowDataKeySelector sortKeySelector = KeySelectorUtil.getRowDataSelector(ctx.classLoader(), orderKeys, (InternalTypeInfo<RowData>)inputRowTypeInfo);
                if (isRowsClause) {
                    return new NonTimeRowsUnboundedPrecedingFunction(config.getStateRetentionTime(), genAggsHandler, generatedRecordEqualiser, generatedSortKeyEqualiser, generatedRecordComparator, flattenAccTypes, fieldTypes, sortKeyTypes, sortKeySelector);
                }
                return new NonTimeRangeUnboundedPrecedingFunction(config.getStateRetentionTime(), genAggsHandler, generatedRecordEqualiser, generatedSortKeyEqualiser, generatedRecordComparator, flattenAccTypes, fieldTypes, sortKeyTypes, sortKeySelector);
            }
        }
        throw new TableException("Unsupported unbounded operation encountered for over aggregate");
    }

    private KeyedProcessFunction<RowData, RowData, RowData> createBoundedOverProcessFunction(CodeGeneratorContext ctx, List<AggregateCall> aggCalls, List<RexLiteral> constants, RowType aggInputType, RowType inputType, boolean isRowsClause, int[] orderKeys, TimeAttribute timeAttribute, long precedingOffset, ExecNodeConfig config, RelBuilder relBuilder, FlinkTypeFactory typeFactory) {
        boolean[] aggCallNeedRetractions = new boolean[aggCalls.size()];
        Arrays.fill(aggCallNeedRetractions, true);
        AggregateInfoList aggInfoList = AggregateUtil.transformToStreamAggregateInfoList(typeFactory, aggInputType, JavaScalaConversionUtil.toScala(aggCalls), aggCallNeedRetractions, true, true, true);
        LogicalType[] fieldTypes = inputType.getChildren().toArray(new LogicalType[0]);
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(ctx, relBuilder, JavaScalaConversionUtil.toScala(Arrays.asList(fieldTypes)), false);
        GeneratedAggsHandleFunction genAggsHandler = generator.needRetract().needAccumulate().withConstants(JavaScalaConversionUtil.toScala(constants)).generateAggsHandler("BoundedOverAggregateHelper", aggInfoList);
        LogicalType[] flattenAccTypes = (LogicalType[])Arrays.stream(aggInfoList.getAccTypes()).map(LogicalTypeDataTypeConverter::fromDataTypeToLogicalType).toArray(LogicalType[]::new);
        switch (timeAttribute) {
            case ROW_TIME: {
                int rowTimeIdx = orderKeys[0];
                if (isRowsClause) {
                    return new RowTimeRowsBoundedPrecedingFunction(config.getStateRetentionTime(), TableConfigUtils.getMaxIdleStateRetentionTime(config), genAggsHandler, flattenAccTypes, fieldTypes, precedingOffset, rowTimeIdx);
                }
                return new RowTimeRangeBoundedPrecedingFunction(genAggsHandler, flattenAccTypes, fieldTypes, precedingOffset, rowTimeIdx);
            }
            case PROC_TIME: {
                if (isRowsClause) {
                    return new ProcTimeRowsBoundedPrecedingFunction(config.getStateRetentionTime(), TableConfigUtils.getMaxIdleStateRetentionTime(config), genAggsHandler, flattenAccTypes, fieldTypes, precedingOffset);
                }
                return new ProcTimeRangeBoundedPrecedingFunction(genAggsHandler, flattenAccTypes, fieldTypes, precedingOffset);
            }
            case NON_TIME: {
                throw new TableException("Non-time attribute sort is not supported for bounded OVER window.");
            }
        }
        throw new TableException("Unsupported bounded operation for OVER window.");
    }
}

