/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonPointer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ContextResolvedModel;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.plan.nodes.exec.serde.CompiledPlanSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;

@Internal
public class ContextResolvedModelJsonDeserializer
extends StdDeserializer<ContextResolvedModel> {
    private static final long serialVersionUID = 1L;
    private static final JsonPointer optionsPointer = JsonPointer.compile((String)"/resolvedModel/options");

    public ContextResolvedModelJsonDeserializer() {
        super(ContextResolvedModel.class);
    }

    public ContextResolvedModel deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        TableConfigOptions.CatalogPlanRestore planRestoreOption = (TableConfigOptions.CatalogPlanRestore)SerdeContext.get((DatabindContext)ctx).getConfiguration().get(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS);
        CatalogManager catalogManager = SerdeContext.get((DatabindContext)ctx).getFlinkContext().getCatalogManager();
        ObjectNode objectNode = (ObjectNode)jsonParser.readValueAsTree();
        ObjectIdentifier identifier = (ObjectIdentifier)ctx.readValue(CompiledPlanSerdeUtil.traverse((TreeNode)objectNode.required("identifier"), jsonParser.getCodec()), ObjectIdentifier.class);
        ResolvedCatalogModel restoredModel = CompiledPlanSerdeUtil.deserializeOptionalField(objectNode, "resolvedModel", ResolvedCatalogModel.class, jsonParser.getCodec(), ctx).orElse(null);
        Optional contextResolvedModelFromCatalog = catalogManager.getModel(identifier);
        if (objectNode.at(optionsPointer).isMissingNode() && CompiledPlanSerdeUtil.isPlanEnforced(planRestoreOption) && contextResolvedModelFromCatalog.map(ContextResolvedModel::isPermanent).orElse(false).booleanValue()) {
            throw ContextResolvedModelJsonDeserializer.lookupDisabled(identifier);
        }
        if (restoredModel != null && contextResolvedModelFromCatalog.isPresent()) {
            ContextResolvedModel modelFromCatalog = (ContextResolvedModel)contextResolvedModelFromCatalog.get();
            if (!CompiledPlanSerdeUtil.areColumnsEqual(restoredModel.getResolvedInputSchema(), modelFromCatalog.getResolvedModel().getResolvedInputSchema())) {
                throw ContextResolvedModelJsonDeserializer.schemaNotMatching(identifier, "input schema", restoredModel.getResolvedInputSchema(), modelFromCatalog.getResolvedModel().getResolvedInputSchema());
            }
            if (!CompiledPlanSerdeUtil.areColumnsEqual(restoredModel.getResolvedOutputSchema(), modelFromCatalog.getResolvedModel().getResolvedOutputSchema())) {
                throw ContextResolvedModelJsonDeserializer.schemaNotMatching(identifier, "output schema", restoredModel.getResolvedInputSchema(), modelFromCatalog.getResolvedModel().getResolvedInputSchema());
            }
        }
        if (restoredModel == null || CompiledPlanSerdeUtil.isLookupForced(planRestoreOption)) {
            return (ContextResolvedModel)contextResolvedModelFromCatalog.orElseThrow(() -> ContextResolvedModelJsonDeserializer.missingModelFromCatalog(identifier, CompiledPlanSerdeUtil.isLookupForced(planRestoreOption)));
        }
        if (contextResolvedModelFromCatalog.isPresent()) {
            if (objectNode.at(optionsPointer).isMissingNode()) {
                return (ContextResolvedModel)contextResolvedModelFromCatalog.get();
            }
            return contextResolvedModelFromCatalog.flatMap(ContextResolvedModel::getCatalog).map(c -> ContextResolvedModel.permanent((ObjectIdentifier)identifier, (Catalog)c, (ResolvedCatalogModel)restoredModel)).orElseGet(() -> ContextResolvedModel.temporary((ObjectIdentifier)identifier, (ResolvedCatalogModel)restoredModel));
        }
        return ContextResolvedModel.temporary((ObjectIdentifier)identifier, (ResolvedCatalogModel)restoredModel);
    }

    static TableException schemaNotMatching(ObjectIdentifier objectIdentifier, String schemaType, ResolvedSchema schemaFromPlan, ResolvedSchema schemaFromCatalog) {
        return new TableException(String.format("The %s of model '%s' from the persisted plan does not match the model loaded from the catalog: '%s' != '%s'. Make sure the model %s in the catalog is still identical.", schemaType, objectIdentifier.asSummaryString(), schemaFromPlan, schemaFromCatalog, schemaType));
    }

    static TableException lookupDisabled(ObjectIdentifier objectIdentifier) {
        return new TableException(String.format("The persisted plan does not include all required catalog metadata for model '%s'. However, lookup is disabled because option '%s' = '%s'. Either enable the catalog lookup with '%s' = '%s' / '%s' or regenerate the plan with '%s' = '%s'. Make sure the model is not compiled as a temporary model.", objectIdentifier.asSummaryString(), TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanRestore.ALL_ENFORCED.name(), TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanRestore.IDENTIFIER.name(), TableConfigOptions.CatalogPlanRestore.ALL.name(), TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanCompilation.ALL.name()));
    }

    static TableException missingModelFromCatalog(ObjectIdentifier identifier, boolean forcedLookup) {
        String initialReason = forcedLookup ? String.format("Cannot resolve model '%s' and catalog lookup is forced because '%s' = '%s'. ", identifier.asSummaryString(), TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanRestore.IDENTIFIER.name()) : String.format("Cannot resolve model '%s' and the persisted plan does not include all required catalog model metadata. ", identifier.asSummaryString());
        return new TableException(initialReason + String.format("Make sure a registered catalog contains the model when restoring or the model is available as a temporary model. Otherwise regenerate the plan with '%s' != '%s' and make sure the model was not compiled as a temporary model.", TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS.key(), TableConfigOptions.CatalogPlanCompilation.IDENTIFIER.name()));
    }
}

