/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.operators.ProcessOperator;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.async.AsyncWaitOperatorFactory;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.connector.source.VectorSearchTableSource;
import org.apache.flink.table.connector.source.search.AsyncVectorSearchFunctionProvider;
import org.apache.flink.table.connector.source.search.VectorSearchFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AsyncVectorSearchFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.functions.VectorSearchFunction;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.FunctionCallCodeGenerator;
import org.apache.flink.table.planner.codegen.VectorSearchCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.spec.VectorSearchSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.VectorSearchTableSourceSpec;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;
import org.apache.flink.table.planner.plan.utils.VectorSearchUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.collector.ListenableCollector;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.operators.search.AsyncVectorSearchRunner;
import org.apache.flink.table.runtime.operators.search.VectorSearchRunner;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public abstract class CommonExecVectorSearchTableFunction
extends ExecNodeBase<RowData> {
    public static final String VECTOR_SEARCH_TRANSFORMATION = "vector-search-table-function";
    protected static final String FIELD_NAME_TABLE_SOURCE_SPEC = "tableSourceSpec";
    protected static final String FIELD_NAME_VECTOR_SEARCH_SPEC = "vectorSearchSpec";
    protected static final String FIELD_NAME_ASYNC_OPTIONS = "asyncOptions";
    @JsonProperty(value="tableSourceSpec")
    protected final VectorSearchTableSourceSpec tableSourceSpec;
    @JsonProperty(value="vectorSearchSpec")
    protected final VectorSearchSpec vectorSearchSpec;
    @JsonProperty(value="asyncOptions")
    @Nullable
    protected final FunctionCallUtil.AsyncOptions asyncOptions;

    protected CommonExecVectorSearchTableFunction(int id, ExecNodeContext context, ReadableConfig persistedConfig, VectorSearchTableSourceSpec tableSourceSpec, VectorSearchSpec vectorSearchSpec, @Nullable FunctionCallUtil.AsyncOptions asyncOptions, List<InputProperty> inputProperties, RowType outputType, String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.tableSourceSpec = tableSourceSpec;
        this.vectorSearchSpec = vectorSearchSpec;
        this.asyncOptions = asyncOptions;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransformation = inputEdge.translateToPlan(planner);
        TableSourceTable searchTable = this.tableSourceSpec.getSearchTable(planner.getFlinkContext(), planner.getTypeFactory());
        boolean isAsyncEnabled = this.asyncOptions != null;
        UserDefinedFunction vectorSearchFunction = this.findVectorSearchFunction(VectorSearchUtil.createVectorSearchRuntimeProvider(searchTable, this.vectorSearchSpec.getSearchColumns().keySet(), (ReadableConfig)Configuration.fromMap(Optional.ofNullable(this.vectorSearchSpec.getRuntimeConfig()).orElse(Collections.emptyMap()))), isAsyncEnabled);
        UserDefinedFunctionHelper.prepareInstance((ReadableConfig)config, (UserDefinedFunction)vectorSearchFunction);
        RowType inputType = (RowType)inputEdge.getOutputType();
        RowType outputType = (RowType)this.getOutputType();
        DataTypeFactory dataTypeFactory = ShortcutUtils.unwrapContext(planner.getFlinkContext()).getCatalogManager().getDataTypeFactory();
        StreamOperatorFactory<RowData> operatorFactory = isAsyncEnabled ? this.createAsyncVectorSearchOperator(searchTable, config, planner.getFlinkContext().getClassLoader(), (AsyncVectorSearchFunction)vectorSearchFunction, dataTypeFactory, inputType, this.vectorSearchSpec.getOutputType(), outputType) : this.createSyncVectorSearchOperator(searchTable, config, planner.getFlinkContext().getClassLoader(), (VectorSearchFunction)vectorSearchFunction, dataTypeFactory, inputType, this.vectorSearchSpec.getOutputType(), outputType);
        return ExecNodeUtil.createOneInputTransformation(inputTransformation, this.createTransformationMeta(VECTOR_SEARCH_TRANSFORMATION, config), operatorFactory, InternalTypeInfo.of((RowType)outputType), inputTransformation.getParallelism(), false);
    }

    private UserDefinedFunction findVectorSearchFunction(VectorSearchTableSource.VectorSearchRuntimeProvider provider, boolean async) {
        if (async) {
            if (provider instanceof AsyncVectorSearchFunctionProvider) {
                return ((AsyncVectorSearchFunctionProvider)provider).createAsyncVectorSearchFunction();
            }
        } else if (provider instanceof VectorSearchFunctionProvider) {
            return ((VectorSearchFunctionProvider)provider).createVectorSearchFunction();
        }
        throw new TableException("Required " + (async ? "async" : "sync") + " vector search function by planner, but VectorSearchRuntimeProvider does not offer a valid vector search function.");
    }

    private StreamOperatorFactory<RowData> createSyncVectorSearchOperator(RelOptTable searchTable, ExecNodeConfig config, ClassLoader jobClassLoader, VectorSearchFunction vectorSearchFunction, DataTypeFactory dataTypeFactory, RowType inputType, RowType searchOutputType, RowType outputType) {
        return SimpleOperatorFactory.of((StreamOperator)new ProcessOperator(this.createSyncVectorSearchFunction(searchTable, config, jobClassLoader, vectorSearchFunction, dataTypeFactory, inputType, searchOutputType, outputType)));
    }

    private ProcessFunction<RowData, RowData> createSyncVectorSearchFunction(RelOptTable searchTable, ExecNodeConfig config, ClassLoader jobClassLoader, VectorSearchFunction vectorSearchFunction, DataTypeFactory dataTypeFactory, RowType inputType, RowType searchOutputType, RowType outputType) {
        ArrayList<FunctionCallUtil.FunctionParam> parameters = new ArrayList<FunctionCallUtil.FunctionParam>(1 + this.vectorSearchSpec.getSearchColumns().size());
        parameters.add(this.vectorSearchSpec.getTopK());
        parameters.addAll(this.vectorSearchSpec.getSearchColumns().values());
        GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedFetcher = VectorSearchCodeGenerator.generateSyncVectorSearchFunction(config, jobClassLoader, dataTypeFactory, (LogicalType)inputType, (LogicalType)searchOutputType, (LogicalType)outputType, parameters, vectorSearchFunction, ((TableSourceTable)searchTable).contextResolvedTable().getIdentifier().asSummaryString(), (Boolean)config.get(PipelineOptions.OBJECT_REUSE));
        GeneratedCollector<ListenableCollector<RowData>> generatedCollector = VectorSearchCodeGenerator.generateCollector(new CodeGeneratorContext(config, jobClassLoader), inputType, searchOutputType, outputType);
        boolean isLeftOuterJoin = this.vectorSearchSpec.getJoinType() == JoinRelType.LEFT;
        return new VectorSearchRunner(generatedFetcher, generatedCollector, isLeftOuterJoin, searchOutputType.getFieldCount());
    }

    private StreamOperatorFactory<RowData> createAsyncVectorSearchOperator(RelOptTable searchTable, ExecNodeConfig config, ClassLoader jobClassLoader, AsyncVectorSearchFunction vectorSearchFunction, DataTypeFactory dataTypeFactory, RowType inputType, RowType searchOutputType, RowType outputType) {
        ArrayList<FunctionCallUtil.FunctionParam> parameters = new ArrayList<FunctionCallUtil.FunctionParam>(1 + this.vectorSearchSpec.getSearchColumns().size());
        parameters.add(this.vectorSearchSpec.getTopK());
        parameters.addAll(this.vectorSearchSpec.getSearchColumns().values());
        FunctionCallCodeGenerator.GeneratedTableFunctionWithDataType<AsyncFunction<RowData, Object>> generatedFetcher = VectorSearchCodeGenerator.generateAsyncVectorSearchFunction(config, jobClassLoader, dataTypeFactory, (LogicalType)inputType, (LogicalType)searchOutputType, (LogicalType)outputType, parameters, vectorSearchFunction, ((TableSourceTable)searchTable).contextResolvedTable().getIdentifier().asSummaryString());
        boolean isLeftOuterJoin = this.vectorSearchSpec.getJoinType() == JoinRelType.LEFT;
        Preconditions.checkNotNull((Object)this.asyncOptions, (String)"Async Options can not be null.");
        return new AsyncWaitOperatorFactory((AsyncFunction)new AsyncVectorSearchRunner(generatedFetcher.tableFunc(), isLeftOuterJoin, this.asyncOptions.asyncBufferCapacity, searchOutputType.getFieldCount()), this.asyncOptions.asyncTimeout, this.asyncOptions.asyncBufferCapacity, this.asyncOptions.asyncOutputMode);
    }
}

