/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import org.apache.flink.sql.parser.dml.SqlTruncateTable;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.TruncateTableOperation;
import org.apache.flink.table.operations.utils.ValidationUtils;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SqlTruncateTableConverter
implements SqlNodeConverter<SqlTruncateTable> {
    @Override
    public Operation convertSqlNode(SqlTruncateTable sqlTruncateTable, SqlNodeConverter.ConvertContext context) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlTruncateTable.fullTableName());
        CatalogManager catalogManager = context.getCatalogManager();
        ObjectIdentifier tableIdentifier = catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ContextResolvedTable contextResolvedTable = catalogManager.getTableOrError(tableIdentifier);
        CatalogBaseTable catalogBaseTable = contextResolvedTable.getTable();
        ValidationUtils.validateTableKind((CatalogBaseTable)catalogBaseTable, (CatalogBaseTable.TableKind)CatalogBaseTable.TableKind.TABLE, (String)"truncate table");
        return new TruncateTableOperation(tableIdentifier);
    }
}

