/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.sql.parser.ddl.SqlAlterTableOptions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.AlterPartitionPropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterTableChangeOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.table.AbstractAlterTableConverter;
import org.apache.flink.table.planner.utils.OperationConverterUtils;

public class SqlAlterTableOptionsConverter
extends AbstractAlterTableConverter<SqlAlterTableOptions> {
    @Override
    protected Operation convertToOperation(SqlAlterTableOptions alterTableOptions, ResolvedCatalogTable oldTable, SqlNodeConverter.ConvertContext context) {
        ObjectIdentifier tableIdentifier = this.getIdentifier(alterTableOptions, context);
        LinkedHashMap<String, String> partitionKVs = alterTableOptions.getPartitionKVs();
        if (partitionKVs != null) {
            CatalogPartitionSpec partitionSpec = new CatalogPartitionSpec(partitionKVs);
            CatalogPartition catalogPartition = (CatalogPartition)context.getCatalogManager().getPartition(tableIdentifier, partitionSpec).orElseThrow(() -> new ValidationException(String.format("Partition %s of table %s doesn't exist", partitionSpec.getPartitionSpec(), tableIdentifier)));
            HashMap<String, String> newProps = new HashMap<String, String>(catalogPartition.getProperties());
            newProps.putAll(OperationConverterUtils.getProperties(alterTableOptions.getPropertyList()));
            return new AlterPartitionPropertiesOperation(tableIdentifier, partitionSpec, (CatalogPartition)new CatalogPartitionImpl(newProps, catalogPartition.getComment()));
        }
        Map<String, String> changeOptions = OperationConverterUtils.getProperties(alterTableOptions.getPropertyList());
        HashMap<String, String> newOptions = new HashMap<String, String>(oldTable.getOptions());
        newOptions.putAll(changeOptions);
        return new AlterTableChangeOperation(tableIdentifier, changeOptions.entrySet().stream().map(entry -> TableChange.set((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList()), (CatalogTable)oldTable.copy(newOptions), alterTableOptions.ifTableExists());
    }
}

