/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSetOperator;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.flink.sql.parser.ddl.SqlAlterView;
import org.apache.flink.sql.parser.error.SqlValidateException;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogView;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.utils.ValidationUtils;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

class SqlNodeConvertUtils {
    SqlNodeConvertUtils() {
    }

    static PlannerQueryOperation toQueryOperation(SqlNode validated, SqlNodeConverter.ConvertContext context) {
        RelRoot relational = context.toRelRoot(validated);
        return new PlannerQueryOperation(relational.project(), () -> context.toQuotedSqlString(validated));
    }

    static CatalogView toCatalogView(SqlNode query, List<SqlNode> viewFields, Map<String, String> viewOptions, String viewComment, SqlNodeConverter.ConvertContext context) {
        String originalQuery = context.toQuotedSqlString(query);
        SqlNode validateQuery = context.getSqlValidator().validate(query);
        SqlValidatorNamespace validatedNamespace = context.getSqlValidator().getNamespace(validateQuery);
        SqlNodeConvertUtils.validateDuplicatedColumnNames(query, viewFields, validatedNamespace);
        String expandedQuery = context.toQuotedSqlString(query);
        PlannerQueryOperation operation = SqlNodeConvertUtils.toQueryOperation(validateQuery, context);
        ResolvedSchema schema = operation.getResolvedSchema();
        if (!viewFields.isEmpty()) {
            List inputFieldNames = schema.getColumnNames();
            List aliasFieldNames = viewFields.stream().map(SqlNode::toString).collect(Collectors.toList());
            if (inputFieldNames.size() != aliasFieldNames.size()) {
                throw new ValidationException(String.format("VIEW definition and input fields not match:\n\tDef fields: %s.\n\tInput fields: %s.", aliasFieldNames, inputFieldNames));
            }
            schema = ResolvedSchema.physical(aliasFieldNames, (List)schema.getColumnDataTypes());
        }
        return new ResolvedCatalogView(CatalogView.of((Schema)Schema.newBuilder().fromResolvedSchema(schema).build(), (String)viewComment, (String)originalQuery, (String)expandedQuery, viewOptions), schema);
    }

    static CatalogView validateAlterView(SqlAlterView alterView, SqlNodeConverter.ConvertContext context) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])alterView.fullViewName());
        ObjectIdentifier viewIdentifier = context.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        Optional optionalCatalogTable = context.getCatalogManager().getTable(viewIdentifier);
        if (!optionalCatalogTable.isPresent() || ((ContextResolvedTable)optionalCatalogTable.get()).isTemporary()) {
            throw new ValidationException(String.format("View %s doesn't exist or is a temporary view.", viewIdentifier));
        }
        ResolvedCatalogBaseTable baseTable = ((ContextResolvedTable)optionalCatalogTable.get()).getResolvedTable();
        ValidationUtils.validateTableKind((CatalogBaseTable)baseTable, (CatalogBaseTable.TableKind)CatalogBaseTable.TableKind.VIEW, (String)"alter view");
        return (CatalogView)baseTable;
    }

    private static void validateDuplicatedColumnNames(SqlNode query, List<SqlNode> viewFields, SqlValidatorNamespace namespace) {
        List<String> columnNameList;
        if (!viewFields.isEmpty()) {
            columnNameList = viewFields.stream().map(SqlNode::toString).collect(Collectors.toList());
        } else {
            Objects.requireNonNull(namespace);
            columnNameList = namespace.getType().getFieldNames();
        }
        HashMap<String, Integer> nameToPos = new HashMap<String, Integer>();
        for (int i = 0; i < columnNameList.size(); ++i) {
            String columnName = columnNameList.get(i);
            if (nameToPos.containsKey(columnName)) {
                SqlSelect select = SqlNodeConvertUtils.extractSelect(query);
                if (select == null) {
                    throw new ValidationException(String.format("SQL validation failed. Column `%s` has been specified.", columnName));
                }
                SqlParserPos errorPos = select.getSelectList().get(i).getParserPosition();
                String msg = String.format("A column with the same name `%s` has been defined at %s.", columnName, select.getSelectList().get((Integer)nameToPos.get(columnName)).getParserPosition());
                throw new ValidationException("SQL validation failed. " + msg, (Throwable)new SqlValidateException(errorPos, msg));
            }
            nameToPos.put(columnName, i);
        }
    }

    @Nullable
    private static SqlSelect extractSelect(SqlNode query) {
        if (query instanceof SqlSelect) {
            return (SqlSelect)query;
        }
        if (query instanceof SqlBasicCall) {
            SqlBasicCall call = (SqlBasicCall)query;
            if (call.getOperator() instanceof SqlSetOperator) {
                return SqlNodeConvertUtils.extractSelect(call.getOperandList().get(0));
            }
            return null;
        }
        if (query instanceof SqlWith) {
            SqlWith with = (SqlWith)query;
            return SqlNodeConvertUtils.extractSelect(with.body);
        }
        return null;
    }
}

