/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.sql.parser.ddl.SqlAlterMaterializedTableAsQuery;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogMaterializedTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableAsQueryOperation;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.converters.AbstractAlterMaterializedTableConverter;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;

public class SqlAlterMaterializedTableAsQueryConverter
extends AbstractAlterMaterializedTableConverter<SqlAlterMaterializedTableAsQuery> {
    @Override
    public Operation convertSqlNode(SqlAlterMaterializedTableAsQuery sqlAlterMaterializedTableAsQuery, SqlNodeConverter.ConvertContext context) {
        ObjectIdentifier identifier = this.resolveIdentifier(sqlAlterMaterializedTableAsQuery, context);
        String originalQuery = context.toQuotedSqlString(sqlAlterMaterializedTableAsQuery.getAsQuery());
        SqlNode validatedQuery = context.getSqlValidator().validate(sqlAlterMaterializedTableAsQuery.getAsQuery());
        String definitionQuery = context.toQuotedSqlString(validatedQuery);
        PlannerQueryOperation queryOperation = new PlannerQueryOperation(context.toRelRoot(validatedQuery).project(), () -> definitionQuery);
        ResolvedCatalogMaterializedTable oldTable = this.getResolvedMaterializedTable(context, identifier, () -> "Only materialized tables support modifying the definition query.");
        List<Column> addedColumns = this.validateAndExtractNewColumns(oldTable.getResolvedSchema(), queryOperation.getResolvedSchema());
        CatalogMaterializedTable updatedTable = this.buildUpdatedMaterializedTable(oldTable, addedColumns, definitionQuery);
        ArrayList<TableChange.ModifyDefinitionQuery> tableChanges = new ArrayList<TableChange.ModifyDefinitionQuery>();
        addedColumns.forEach(column -> tableChanges.add((TableChange.ModifyDefinitionQuery)TableChange.add((Column)column)));
        tableChanges.add(TableChange.modifyDefinitionQuery((String)definitionQuery));
        return new AlterMaterializedTableAsQueryOperation(identifier, tableChanges, updatedTable);
    }

    private CatalogMaterializedTable buildUpdatedMaterializedTable(ResolvedCatalogMaterializedTable oldTable, List<Column> addedColumns, String definitionQuery) {
        Schema.Builder newSchemaBuilder = Schema.newBuilder().fromResolvedSchema(oldTable.getResolvedSchema());
        addedColumns.forEach(col -> newSchemaBuilder.column(col.getName(), (AbstractDataType)col.getDataType()));
        return this.buildUpdatedMaterializedTable(oldTable, builder -> {
            builder.schema(newSchemaBuilder.build());
            builder.definitionQuery(definitionQuery);
        });
    }

    private List<Column> validateAndExtractNewColumns(ResolvedSchema oldSchema, ResolvedSchema newSchema) {
        int i;
        int newColumnSize;
        ArrayList<Column> newAddedColumns = new ArrayList<Column>();
        int originalColumnSize = oldSchema.getColumns().size();
        if (originalColumnSize > (newColumnSize = newSchema.getColumns().size())) {
            throw new ValidationException(String.format("Failed to modify query because drop column is unsupported. When modifying a query, you can only append new columns at the end of original schema. The original schema has %d columns, but the newly derived schema from the query has %d columns.", originalColumnSize, newColumnSize));
        }
        for (i = 0; i < oldSchema.getColumns().size(); ++i) {
            Column newColumn;
            Column oldColumn = (Column)oldSchema.getColumns().get(i);
            if (oldColumn.equals((Object)(newColumn = (Column)newSchema.getColumns().get(i)))) continue;
            throw new ValidationException(String.format("When modifying the query of a materialized table, currently only support appending columns at the end of original schema, dropping, renaming, and reordering columns are not supported.\nColumn mismatch at position %d: Original column is [%s], but new column is [%s].", i, oldColumn, newColumn));
        }
        for (i = oldSchema.getColumns().size(); i < newSchema.getColumns().size(); ++i) {
            Column newColumn = (Column)newSchema.getColumns().get(i);
            newAddedColumns.add(newColumn.copy((DataType)newColumn.getDataType().nullable()));
        }
        return newAddedColumns;
    }
}

