/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.functions.DeclarativeAggregateFunction;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.TimestampType;

public abstract class LeadLagAggFunction
extends DeclarativeAggregateFunction {
    private final int operandCount;
    private final boolean existDefaultValue;
    private final UnresolvedReferenceExpression value = ApiExpressionUtils.unresolvedRef((String)"leadlag");

    public LeadLagAggFunction(int operandCount) {
        this.operandCount = operandCount;
        this.existDefaultValue = operandCount == 3;
    }

    public int operandCount() {
        return this.operandCount;
    }

    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.value};
    }

    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getResultType()};
    }

    public Expression[] initialValuesExpressions() {
        return new Expression[]{ExpressionBuilder.literal(null, this.getResultType())};
    }

    public Expression[] accumulateExpressions() {
        return new Expression[]{this.operand(0)};
    }

    public Expression[] retractExpressions() {
        return new Expression[]{this.existDefaultValue ? ExpressionBuilder.cast((Expression)this.operand(2), (Expression)ExpressionBuilder.typeLiteral(this.getResultType())) : ExpressionBuilder.literal(null, this.getResultType())};
    }

    public Expression[] mergeExpressions() {
        return new Expression[0];
    }

    public Expression getValueExpression() {
        return this.value;
    }

    public static class TimestampLeadLagAggFunction
    extends LeadLagAggFunction {
        private final TimestampType type;

        public TimestampLeadLagAggFunction(int operandCount, TimestampType type) {
            super(operandCount);
            this.type = type;
        }

        public DataType getResultType() {
            return DataTypes.TIMESTAMP((int)this.type.getPrecision());
        }
    }

    public static class TimeLeadLagAggFunction
    extends LeadLagAggFunction {
        public TimeLeadLagAggFunction(int operandCount) {
            super(operandCount);
        }

        public DataType getResultType() {
            return DataTypes.TIME((int)0);
        }
    }

    public static class DateLeadLagAggFunction
    extends LeadLagAggFunction {
        public DateLeadLagAggFunction(int operandCount) {
            super(operandCount);
        }

        public DataType getResultType() {
            return DataTypes.DATE();
        }
    }

    public static class CharLeadLagAggFunction
    extends LeadLagAggFunction {
        private final CharType type;

        public CharLeadLagAggFunction(int operandCount, CharType type) {
            super(operandCount);
            this.type = type;
        }

        public DataType getResultType() {
            return DataTypes.CHAR((int)this.type.getLength());
        }
    }

    public static class StringLeadLagAggFunction
    extends LeadLagAggFunction {
        public StringLeadLagAggFunction(int operandCount) {
            super(operandCount);
        }

        public DataType getResultType() {
            return DataTypes.STRING();
        }
    }

    public static class DecimalLeadLagAggFunction
    extends LeadLagAggFunction {
        private final DecimalType decimalType;

        public DecimalLeadLagAggFunction(int operandCount, DecimalType decimalType) {
            super(operandCount);
            this.decimalType = decimalType;
        }

        public DataType getResultType() {
            return DataTypes.DECIMAL((int)this.decimalType.getPrecision(), (int)this.decimalType.getScale());
        }
    }

    public static class BooleanLeadLagAggFunction
    extends LeadLagAggFunction {
        public BooleanLeadLagAggFunction(int operandCount) {
            super(operandCount);
        }

        public DataType getResultType() {
            return DataTypes.BOOLEAN();
        }
    }

    public static class DoubleLeadLagAggFunction
    extends LeadLagAggFunction {
        public DoubleLeadLagAggFunction(int operandCount) {
            super(operandCount);
        }

        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }
    }

    public static class FloatLeadLagAggFunction
    extends LeadLagAggFunction {
        public FloatLeadLagAggFunction(int operandCount) {
            super(operandCount);
        }

        public DataType getResultType() {
            return DataTypes.FLOAT();
        }
    }

    public static class LongLeadLagAggFunction
    extends LeadLagAggFunction {
        public LongLeadLagAggFunction(int operandCount) {
            super(operandCount);
        }

        public DataType getResultType() {
            return DataTypes.BIGINT();
        }
    }

    public static class ShortLeadLagAggFunction
    extends LeadLagAggFunction {
        public ShortLeadLagAggFunction(int operandCount) {
            super(operandCount);
        }

        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }
    }

    public static class ByteLeadLagAggFunction
    extends LeadLagAggFunction {
        public ByteLeadLagAggFunction(int operandCount) {
            super(operandCount);
        }

        public DataType getResultType() {
            return DataTypes.TINYINT();
        }
    }

    public static class IntLeadLagAggFunction
    extends LeadLagAggFunction {
        public IntLeadLagAggFunction(int operandCount) {
            super(operandCount);
        }

        public DataType getResultType() {
            return DataTypes.INT();
        }
    }
}

