/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.connectors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsWritingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.utils.TransformationMetadata;
import org.apache.flink.table.runtime.operators.sink.OutputConversionOperator;
import org.apache.flink.table.runtime.typeutils.ExternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
final class ExternalDynamicSink
implements DynamicTableSink,
SupportsWritingMetadata {
    private static final String EXTERNAL_DATASTREAM_TRANSFORMATION = "external-datastream";
    private static final String ROWTIME_METADATA_KEY = "rowtime";
    private static final DataType ROWTIME_METADATA_DATA_TYPE = (DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull();
    @Nullable
    private final ChangelogMode changelogMode;
    private final DataType physicalDataType;
    private boolean consumeRowtimeMetadata;

    ExternalDynamicSink(@Nullable ChangelogMode changelogMode, DataType physicalDataType) {
        this.changelogMode = changelogMode;
        this.physicalDataType = physicalDataType;
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        if (this.changelogMode == null) {
            return requestedMode;
        }
        return this.changelogMode;
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        DynamicTableSink.DataStructureConverter physicalConverter = context.createDataStructureConverter(this.physicalDataType);
        return transformationContext -> {
            Transformation input = transformationContext.getInputTransformation();
            LogicalType physicalType = this.physicalDataType.getLogicalType();
            RowData.FieldGetter atomicFieldGetter = LogicalTypeChecks.isCompositeType((LogicalType)physicalType) ? null : RowData.createFieldGetter((LogicalType)physicalType, (int)0);
            TransformationMetadata transformationMeta = transformationContext.generateUid(EXTERNAL_DATASTREAM_TRANSFORMATION).map(uid -> new TransformationMetadata((String)uid, this.generateOperatorName(), this.generateOperatorDesc())).orElseGet(() -> new TransformationMetadata(this.generateOperatorName(), this.generateOperatorDesc()));
            return ExecNodeUtil.createOneInputTransformation(input, transformationMeta, new OutputConversionOperator(atomicFieldGetter, physicalConverter, transformationContext.getRowtimeIndex(), this.consumeRowtimeMetadata), ExternalTypeInfo.of((DataType)this.physicalDataType), input.getParallelism(), false);
        };
    }

    private String generateOperatorName() {
        return "TableToDataStream";
    }

    private String generateOperatorDesc() {
        return String.format("TableToDataStream(type=%s, rowtime=%s)", this.physicalDataType.toString(), this.consumeRowtimeMetadata);
    }

    public DynamicTableSink copy() {
        return new ExternalDynamicSink(this.changelogMode, this.physicalDataType);
    }

    public String asSummaryString() {
        return this.generateOperatorName();
    }

    public Map<String, DataType> listWritableMetadata() {
        return Collections.singletonMap(ROWTIME_METADATA_KEY, ROWTIME_METADATA_DATA_TYPE);
    }

    public void applyWritableMetadata(List<String> metadataKeys, DataType consumedDataType) {
        this.consumeRowtimeMetadata = metadataKeys.contains(ROWTIME_METADATA_KEY);
    }
}

