/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class PartiallyOrderedSet<E>
extends AbstractSet<E> {
    public static final Ordering<ImmutableBitSet> BIT_SET_INCLUSION_ORDERING = ImmutableBitSet::contains;
    private final Map<E, Node<E>> map;
    private final @Nullable Function<E, Iterable<E>> parentFunction;
    private final @Nullable Function<E, Iterable<E>> childFunction;
    private final Ordering<E> ordering;
    private final Node<E> topNode;
    private final Node<E> bottomNode;

    public PartiallyOrderedSet(Ordering<E> ordering) {
        this(ordering, new HashMap(), null, null);
    }

    public PartiallyOrderedSet(Ordering<E> ordering, Function<E, Iterable<E>> childFunction, Function<E, Iterable<E>> parentFunction) {
        this(ordering, new HashMap(), childFunction, parentFunction);
    }

    @Deprecated
    public PartiallyOrderedSet(Ordering<E> ordering, org.apache.flink.calcite.shaded.com.google.common.base.Function<E, Iterable<E>> childFunction, org.apache.flink.calcite.shaded.com.google.common.base.Function<E, Iterable<E>> parentFunction) {
        this(ordering, childFunction::apply, parentFunction::apply);
    }

    public PartiallyOrderedSet(Ordering<E> ordering, Collection<E> collection) {
        this(ordering, new HashMap(collection.size() * 3 / 2), null, null);
        this.addAll(collection);
    }

    private PartiallyOrderedSet(Ordering<E> ordering, Map<E, Node<E>> map, @Nullable Function<E, Iterable<E>> childFunction, @Nullable Function<E, Iterable<E>> parentFunction) {
        this.ordering = ordering;
        this.map = map;
        this.childFunction = childFunction;
        this.parentFunction = parentFunction;
        this.topNode = new TopBottomNode(true);
        this.bottomNode = new TopBottomNode(false);
        this.topNode.childList.add(this.bottomNode);
        this.bottomNode.parentList.add(this.topNode);
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<E> iterator = this.map.keySet().iterator();
        return new Iterator<E>(){
            @Nullable E previous;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                this.previous = iterator.next();
                return this.previous;
            }

            @Override
            public void remove() {
                if (!PartiallyOrderedSet.this.remove(this.previous)) {
                    throw new IllegalStateException();
                }
            }
        };
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean remove(@Nullable Object o) {
        int i;
        Node<E> node = this.map.remove(o);
        if (node == null) {
            return false;
        }
        for (i = 0; i < node.parentList.size(); ++i) {
            Node parent = node.parentList.get(i);
            for (Node child : node.childList) {
                if (parent.e == null && child.e == null) {
                    parent.childList.remove(node);
                    continue;
                }
                PartiallyOrderedSet.replace(parent.childList, node, child);
            }
        }
        for (i = 0; i < node.childList.size(); ++i) {
            Node child = node.childList.get(i);
            for (Node parent : node.parentList) {
                if (child.e == null && parent.e == null) {
                    child.parentList.remove(node);
                    continue;
                }
                PartiallyOrderedSet.replace(child.parentList, node, parent);
            }
        }
        return true;
    }

    @Override
    public boolean add(E e) {
        assert (e != null);
        assert (!CalciteSystemProperty.DEBUG.value().booleanValue() || this.isValid(true));
        Node<E> node = this.map.get(e);
        if (node != null) {
            return false;
        }
        Set<Node<E>> parents = this.findParents(e);
        Set<Node<E>> children = this.findChildren(e);
        node = new Node<E>(e);
        for (Node<E> parent : parents) {
            node.parentList.add(parent);
            int n = 0;
            for (int i = 0; i < parent.childList.size(); ++i) {
                Node child = parent.childList.get(i);
                if (child.e != null && !this.ordering.lessThan(child.e, e)) continue;
                if (parent.childList.contains(node)) {
                    parent.childList.remove(i);
                    --i;
                } else {
                    parent.childList.set(i, node);
                }
                PartiallyOrderedSet.replace(child.parentList, parent, node);
                if (!node.childList.contains(child)) {
                    node.childList.add(child);
                }
                ++n;
            }
            if (n != 0) continue;
            parent.childList.add(node);
        }
        HashSet childSet = new HashSet(node.childList);
        for (Node<E> child : children) {
            if (this.isDescendantOfAny(child, childSet)) continue;
            node.childList.add(child);
            if (child.parentList.contains(node)) continue;
            child.parentList.add(node);
        }
        this.map.put(node.e, node);
        assert (!CalciteSystemProperty.DEBUG.value().booleanValue() || this.isValid(true));
        return true;
    }

    private boolean isDescendantOfAny(Node<E> node, Set<Node<E>> nodeSet) {
        ArrayDeque deque = new ArrayDeque();
        HashSet seen = new HashSet();
        deque.add(node);
        while (!deque.isEmpty()) {
            Node node1 = (Node)deque.pop();
            if (nodeSet.contains(node1)) {
                return true;
            }
            for (Node parent : node1.parentList) {
                if (!seen.add(parent)) continue;
                deque.add(parent);
            }
        }
        return false;
    }

    private Set<Node<E>> findChildren(E e) {
        ArrayDeque<Node<Node<E>>> descendants = new ArrayDeque<Node<Node<E>>>();
        descendants.add(this.bottomNode);
        return this.findParentsChildren(e, descendants, false);
    }

    private Set<Node<E>> findParents(E e) {
        ArrayDeque<Node<Node<E>>> ancestors = new ArrayDeque<Node<Node<E>>>();
        ancestors.add(this.topNode);
        return this.findParentsChildren(e, ancestors, true);
    }

    private Set<Node<E>> findParentsChildren(E e, Deque<Node<E>> ancestors, boolean up) {
        HashSet<Node<Node<E>>> parents = new HashSet<Node<Node<E>>>();
        while (!ancestors.isEmpty()) {
            Node<E> ancestor = ancestors.pop();
            assert (ancestor.e == null || (!up ? !this.ordering.lessThan(e, ancestor.e) : !this.ordering.lessThan(ancestor.e, e)));
            assert (ancestor.e != e);
            int found = 0;
            for (Node child : up ? ancestor.childList : ancestor.parentList) {
                if (child.e == null) continue;
                if (up ? this.ordering.lessThan(e, child.e) : this.ordering.lessThan(child.e, e)) {
                    ancestors.add(child);
                    ++found;
                    continue;
                }
                if (!(up ? !this.ordering.lessThan(child.e, e) : !this.ordering.lessThan(e, child.e))) continue;
                ancestors.add(child);
            }
            if (found != 0 || ancestor.e != null && !(up ? this.ordering.lessThan(e, ancestor.e) : this.ordering.lessThan(ancestor.e, e))) continue;
            parents.add(ancestor);
        }
        return parents;
    }

    private static <T> void replace(List<T> list, T remove, T add) {
        if (list.contains(add)) {
            list.remove(remove);
        } else {
            int index = list.indexOf(remove);
            if (index >= 0) {
                list.set(index, add);
            } else {
                list.add(add);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValid(boolean fail) {
        for (Node<E> node : this.map.values()) {
            void var4_6;
            if (node == this.topNode != node.parentList.isEmpty()) {
                assert (!fail) : "only top node should have no parents " + node + ", parents " + node.parentList;
                return false;
            }
            if (node == this.bottomNode != node.childList.isEmpty()) {
                assert (!fail) : "only bottom node should have no children " + node + ", children " + node.childList;
                return false;
            }
            boolean bl = false;
            while (var4_6 < node.childList.size()) {
                Node child = node.childList.get((int)var4_6);
                if (!child.parentList.contains(node)) {
                    assert (!fail) : "child " + child + " of " + node + " does not know its parent";
                    return false;
                }
                if (child.e != null && !this.ordering.lessThan(child.e, node.e)) {
                    assert (!fail) : "child " + child.e + " not less than parent " + node.e;
                    return false;
                }
                for (int i2 = 0; i2 < node.childList.size(); ++i2) {
                    Node child2 = node.childList.get(i2);
                    if (child == child2 && var4_6 != i2) {
                        assert (!fail) : "duplicate child " + child + " of parent " + node;
                        return false;
                    }
                    if (child.e == null || child2.e == null || child == child2 || !this.ordering.lessThan(child.e, child2.e)) continue;
                    assert (!fail) : "relation between children " + child.e + " and " + child2.e + " of node " + node.e;
                    return false;
                }
                ++var4_6;
            }
            for (Node parent : node.parentList) {
                if (parent.childList.contains(node)) continue;
                assert (!fail);
                return false;
            }
        }
        HashMap<Node, Integer> distanceToRoot = new HashMap<Node, Integer>();
        this.distanceRecurse(distanceToRoot, this.topNode, 0);
        for (Node node : this.map.values()) {
            if (distanceToRoot.containsKey(node)) continue;
            assert (!fail) : "node " + node + " is not reachable";
            return false;
        }
        HashMap<Node<E>, Set<E>> nodeAncestors = new HashMap<Node<E>, Set<E>>();
        HashMap<Node<E>, Set<E>> hashMap = new HashMap<Node<E>, Set<E>>();
        for (Node<E> node : this.map.values()) {
            nodeAncestors.put(node, new HashSet(this.getAncestors(node.e)));
            hashMap.put(node, new HashSet(this.getDescendants(node.e)));
        }
        for (Node<E> node1 : this.map.values()) {
            for (Node<E> node2 : this.map.values()) {
                boolean lt12 = this.ordering.lessThan(node1.e, node2.e);
                boolean lt21 = this.ordering.lessThan(node2.e, node1.e);
                if (node1 == node2 && (!lt12 || !lt21)) assert (!fail) : "self should be less than self: " + node1;
                if (lt12 && lt21 && node1 != node2) {
                    assert (!fail) : "node " + node1.e + " and node " + node2.e + " are less than each other but are not the same value";
                    return false;
                }
                if (lt12 && !lt21) {
                    if (!PartiallyOrderedSet.get(nodeAncestors, node1, "nodeAncestors").contains(node2.e)) {
                        assert (!fail) : node1.e + " is less than " + node2.e + " but " + node2.e + " is not in the ancestor set of " + node1.e;
                        return false;
                    }
                    if (!PartiallyOrderedSet.get(hashMap, node2, "nodeDescendants").contains(node1.e)) {
                        assert (!fail) : node1.e + " is less than " + node2.e + " but " + node1.e + " is not in the descendant set of " + node2.e;
                        return false;
                    }
                }
                if (!lt21 || lt12) continue;
                if (!PartiallyOrderedSet.get(nodeAncestors, node2, "nodeAncestors").contains(node1.e)) {
                    assert (!fail) : node2.e + " is less than " + node1.e + " but " + node1.e + " is not in the ancestor set of " + node2.e;
                    return false;
                }
                if (PartiallyOrderedSet.get(hashMap, node1, "nodeDescendants").contains(node2.e)) continue;
                assert (!fail) : node2.e + " is less than " + node1.e + " but " + node2.e + " is not in the descendant set of " + node1.e;
                return false;
            }
        }
        return true;
    }

    private static <E> Set<E> get(Map<Node<E>, Set<E>> map, Node<E> node, String label) {
        return Objects.requireNonNull(map.get(node), () -> label + " for node " + node);
    }

    private void distanceRecurse(Map<Node, Integer> distanceToRoot, Node<E> node, int distance) {
        Integer best = distanceToRoot.get(node);
        if (best == null || distance < best) {
            distanceToRoot.put(node, distance);
        }
        if (best != null) {
            return;
        }
        for (Node child : node.childList) {
            this.distanceRecurse(distanceToRoot, child, distance + 1);
        }
    }

    public void out(StringBuilder buf) {
        buf.append("PartiallyOrderedSet size: ");
        buf.append(this.size());
        buf.append(" elements: {\n");
        HashSet seen = new HashSet();
        ArrayDeque unseen = new ArrayDeque(this.getNonChildren());
        while (!unseen.isEmpty()) {
            Object e = unseen.pop();
            buf.append("  ");
            buf.append(e);
            buf.append(" parents: ");
            List parents = this.getParents(e);
            buf.append(parents);
            buf.append(" children: ");
            List children = this.getChildren(e);
            buf.append(children);
            buf.append("\n");
            if (children == null) continue;
            for (Object child : children) {
                if (!seen.add(child)) continue;
                unseen.add(child);
            }
        }
        buf.append("}");
    }

    public @Nullable List<E> getChildren(E e) {
        return this.getChildren(e, false);
    }

    public @Nullable List<E> getChildren(E e, boolean hypothetical) {
        Node<E> node = this.map.get(e);
        if (node == null) {
            if (hypothetical) {
                return PartiallyOrderedSet.strip(this.findChildren(e));
            }
            return null;
        }
        return PartiallyOrderedSet.strip(node.childList);
    }

    public @Nullable List<E> getParents(E e) {
        return this.getParents(e, false);
    }

    public @Nullable List<E> getParents(E e, boolean hypothetical) {
        Node<E> node = this.map.get(e);
        if (node == null) {
            if (hypothetical) {
                if (this.parentFunction != null) {
                    ImmutableList.Builder list = new ImmutableList.Builder();
                    this.closure(this.parentFunction, e, list, new HashSet());
                    return list.build();
                }
                return ImmutableList.copyOf(PartiallyOrderedSet.strip(this.findParents(e)));
            }
            return null;
        }
        return ImmutableList.copyOf(PartiallyOrderedSet.strip(node.parentList));
    }

    private void closure(Function<E, Iterable<E>> generator, E e, ImmutableList.Builder<E> list, Set<E> set) {
        for (E p : Objects.requireNonNull(generator.apply(e))) {
            if (!set.add(e)) continue;
            if (this.map.containsKey(p)) {
                list.add((Object)p);
                continue;
            }
            this.closure(generator, p, list, set);
        }
    }

    public List<E> getNonChildren() {
        return PartiallyOrderedSet.strip(this.topNode.childList);
    }

    public List<E> getNonParents() {
        return PartiallyOrderedSet.strip(this.bottomNode.parentList);
    }

    @Override
    public void clear() {
        this.map.clear();
        assert (this.topNode.parentList.isEmpty());
        this.topNode.childList.clear();
        this.topNode.childList.add(this.bottomNode);
        assert (this.bottomNode.childList.isEmpty());
        this.bottomNode.parentList.clear();
        this.bottomNode.parentList.add(this.topNode);
    }

    public List<E> getDescendants(E e) {
        return this.descendants(e, true);
    }

    public static <E> List<E> strip(List<Node<E>> list) {
        if (list.size() == 1 && list.get((int)0).e == null) {
            return ImmutableList.of();
        }
        return Util.transform(list, node -> node.e);
    }

    private static <E> ImmutableList<E> strip(Iterable<Node<E>> iterable) {
        Iterator<Node<E>> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return ImmutableList.of();
        }
        Node<E> node = iterator.next();
        if (!iterator.hasNext()) {
            if (node.e == null) {
                return ImmutableList.of();
            }
            return ImmutableList.of(node.e);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        while (true) {
            builder.add(node.e);
            if (!iterator.hasNext()) {
                return builder.build();
            }
            node = iterator.next();
        }
    }

    public List<E> getAncestors(E e) {
        return this.descendants(e, false);
    }

    private List<E> descendants(E e, boolean up) {
        Collection c;
        Node<E> node = this.map.get(e);
        if (node == null) {
            c = up ? this.findChildren(e) : this.findParents(e);
        } else {
            Collection collection = c = up ? node.childList : node.parentList;
        }
        if (c.size() == 1 && c.iterator().next().e == null) {
            return Collections.emptyList();
        }
        ArrayDeque deque = new ArrayDeque(c);
        HashSet seen = new HashSet();
        ImmutableList.Builder list = new ImmutableList.Builder();
        block0: while (!deque.isEmpty()) {
            Node node1 = (Node)deque.pop();
            list.add(node1.e);
            for (Node child : up ? node1.childList : node1.parentList) {
                if (child.e == null) continue block0;
                if (!seen.add(child)) continue;
                deque.add(child);
            }
        }
        return list.build();
    }

    public static interface Ordering<E> {
        public boolean lessThan(E var1, E var2);
    }

    private static class TopBottomNode<E>
    extends Node<E> {
        private final String description;

        TopBottomNode(boolean top) {
            super(Nullness.castNonNull(null));
            this.description = top ? "top" : "bottom";
        }

        @Override
        public String toString() {
            return this.description;
        }
    }

    private static class Node<E> {
        final List<Node<E>> parentList = new ArrayList<Node<E>>();
        final List<Node<E>> childList = new ArrayList<Node<E>>();
        final E e;

        Node(E e) {
            this.e = e;
        }

        public String toString() {
            return String.valueOf(this.e);
        }
    }
}

