/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema;

import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class Statistics {
    public static final Statistic UNKNOWN = new Statistic(){};

    private Statistics() {
    }

    public static Statistic of(@Nullable List<RelReferentialConstraint> referentialConstraints) {
        return Statistics.of(null, null, referentialConstraints, null);
    }

    public static Statistic of(double rowCount, @Nullable List<ImmutableBitSet> keys) {
        return Statistics.of(rowCount, keys, null, null);
    }

    public static Statistic of(double rowCount, @Nullable List<ImmutableBitSet> keys, @Nullable List<RelCollation> collations) {
        return Statistics.of(rowCount, keys, null, collations);
    }

    public static Statistic of(final @Nullable Double rowCount, @Nullable List<ImmutableBitSet> keys, @Nullable List<RelReferentialConstraint> referentialConstraints, @Nullable List<RelCollation> collations) {
        final ImmutableList<Object> keysCopy = keys == null ? ImmutableList.of() : ImmutableList.copyOf(keys);
        final ImmutableList<RelReferentialConstraint> referentialConstraintsCopy = referentialConstraints == null ? null : ImmutableList.copyOf(referentialConstraints);
        final ImmutableList<RelCollation> collationsCopy = collations == null ? null : ImmutableList.copyOf(collations);
        return new Statistic(){

            @Override
            public @Nullable Double getRowCount() {
                return rowCount;
            }

            @Override
            public boolean isKey(ImmutableBitSet columns) {
                for (ImmutableBitSet key : keysCopy) {
                    if (!columns.contains(key)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public @Nullable List<ImmutableBitSet> getKeys() {
                return keysCopy;
            }

            @Override
            public @Nullable List<RelReferentialConstraint> getReferentialConstraints() {
                return referentialConstraintsCopy;
            }

            @Override
            public @Nullable List<RelCollation> getCollations() {
                return collationsCopy;
            }
        };
    }
}

