/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata.janino;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.janino.CacheGeneratorUtil;
import org.apache.calcite.rel.metadata.janino.DispatchGenerator;
import org.apache.calcite.rel.metadata.janino.ImmutableHandlerNameAndGeneratedCode;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

public class RelMetadataHandlerGeneratorUtil {
    private static final String LICENSE = "/*\n * Licensed to the Apache Software Foundation (ASF) under one or more\n * contributor license agreements.  See the NOTICE file distributed with\n * this work for additional information regarding copyright ownership.\n * The ASF licenses this file to you under the Apache License, Version 2.0\n * (the \"License\"); you may not use this file except in compliance with\n * the License.  You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n";

    private RelMetadataHandlerGeneratorUtil() {
    }

    public static HandlerNameAndGeneratedCode generateHandler(Class<? extends MetadataHandler<?>> handlerClass, List<? extends MetadataHandler<?>> handlers) {
        String classPackage = Nullness.castNonNull(RelMetadataHandlerGeneratorUtil.class.getPackage()).getName();
        String name = "GeneratedMetadata_" + RelMetadataHandlerGeneratorUtil.simpleNameForHandler(handlerClass);
        SortedMap<String, Method> declaredMethods = MetadataHandler.handlerMethods(handlerClass);
        LinkedHashMap handlerToName = new LinkedHashMap();
        for (MetadataHandler<?> metadataHandler : handlers) {
            handlerToName.put(metadataHandler, "provider" + handlerToName.size());
        }
        StringBuilder buff = new StringBuilder();
        buff.append(LICENSE).append("package ").append(classPackage).append(";\n\n");
        buff.append("public final class ").append(name).append("\n").append("  implements ").append(handlerClass.getCanonicalName()).append(" {\n");
        Ord.forEach(declaredMethods.values(), (declaredMethod, i) -> CacheGeneratorUtil.cacheProperties(buff, declaredMethod, i));
        for (Map.Entry handlerAndName : handlerToName.entrySet()) {
            buff.append("  public final ").append(((MetadataHandler)handlerAndName.getKey()).getClass().getName()).append(' ').append((String)handlerAndName.getValue()).append(";\n");
        }
        buff.append("  public ").append(name).append("(\n");
        for (Map.Entry handlerAndName : handlerToName.entrySet()) {
            buff.append("      ").append(((MetadataHandler)handlerAndName.getKey()).getClass().getName()).append(' ').append((String)handlerAndName.getValue()).append(",\n");
        }
        if (!handlerToName.isEmpty()) {
            buff.setLength(buff.length() - 2);
        }
        buff.append(") {\n");
        for (String handlerName : handlerToName.values()) {
            buff.append("    this.").append(handlerName).append(" = ").append(handlerName).append(";\n");
        }
        buff.append("  }\n");
        RelMetadataHandlerGeneratorUtil.getDefMethod(buff, handlerToName.values().stream().findFirst().orElse(null));
        DispatchGenerator dispatchGenerator = new DispatchGenerator(handlerToName);
        Ord.forEach(declaredMethods.values(), (declaredMethod, i) -> {
            CacheGeneratorUtil.cachedMethod(buff, declaredMethod, i);
            dispatchGenerator.dispatchMethod(buff, (Method)declaredMethod, (Collection<? extends MetadataHandler<?>>)handlers);
        });
        buff.append("\n}\n");
        return ImmutableHandlerNameAndGeneratedCode.builder().withHandlerName(classPackage + "." + name).withGeneratedCode(buff.toString()).build();
    }

    private static void getDefMethod(StringBuilder buff, @Nullable String handlerName) {
        buff.append("  public ").append(MetadataDef.class.getName()).append(" getDef() {\n");
        if (handlerName == null) {
            buff.append("    return null;");
        } else {
            buff.append("    return ").append(handlerName).append(".getDef();\n");
        }
        buff.append("  }\n");
    }

    private static String simpleNameForHandler(Class<? extends MetadataHandler<?>> clazz) {
        String simpleName = clazz.getSimpleName();
        if (simpleName.equals("Handler")) {
            String[] parts = clazz.getName().split("[.$]");
            return parts[parts.length - 2] + parts[parts.length - 1];
        }
        return simpleName;
    }

    @Value.Immutable(singleton=false)
    public static interface HandlerNameAndGeneratedCode {
        public String getHandlerName();

        public String getGeneratedCode();
    }
}

