/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.StructuredType;

@Internal
public class ObjectOfTypeStrategy
implements TypeStrategy {
    private static DataType toStructuredType(String className, CallContext callContext) {
        DataTypeFactory dataTypeFactory = callContext.getDataTypeFactory();
        ClassLoader classLoader = dataTypeFactory.getClassLoader();
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        DataTypes.Field[] fields = (DataTypes.Field[])IntStream.iterate(1, i -> i < argumentDataTypes.size(), i -> i + 2).mapToObj(keyIdx -> ObjectOfTypeStrategy.toFieldDataType(callContext, keyIdx)).toArray(DataTypes.Field[]::new);
        Optional<Class<?>> resolveClass = StructuredType.resolveClass(classLoader, className);
        return resolveClass.map(clazz -> DataTypes.STRUCTURED(clazz, fields)).orElse(DataTypes.STRUCTURED(className, fields));
    }

    private static DataTypes.Field toFieldDataType(CallContext callContext, int keyIdx) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        String fieldName = callContext.getArgumentValue(keyIdx, String.class).orElseThrow(IllegalStateException::new);
        DataType fieldDataType = argumentDataTypes.get(keyIdx + 1);
        return DataTypes.FIELD(fieldName, fieldDataType);
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        Optional<String> argumentValue = callContext.getArgumentValue(0, String.class);
        return argumentValue.map(className -> ObjectOfTypeStrategy.toStructuredType(className, callContext));
    }
}

