/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.wmstrategies;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.table.sources.wmstrategies.PeriodicWatermarkAssigner;

@PublicEvolving
public final class AscendingTimestamps
extends PeriodicWatermarkAssigner {
    private static final long serialVersionUID = 1L;
    private long maxTimestamp = -9223372036854775807L;

    @Override
    public void nextTimestamp(long timestamp) {
        if (timestamp > this.maxTimestamp) {
            this.maxTimestamp = timestamp;
        }
    }

    @Override
    public Map<String, String> toProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rowtime.watermarks.type", "periodic-ascending");
        return map;
    }

    public int hashCode() {
        return AscendingTimestamps.class.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof AscendingTimestamps;
    }

    @Override
    public Watermark getWatermark() {
        return new Watermark(this.maxTimestamp - 1L);
    }
}

