/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;

@Internal
public class CreateViewOperation
implements CreateOperation {
    private final ObjectIdentifier viewIdentifier;
    private final CatalogView catalogView;
    private final boolean ignoreIfExists;
    private final boolean isTemporary;

    public CreateViewOperation(ObjectIdentifier viewIdentifier, CatalogView catalogView, boolean ignoreIfExists, boolean isTemporary) {
        this.viewIdentifier = viewIdentifier;
        this.catalogView = catalogView;
        this.ignoreIfExists = ignoreIfExists;
        this.isTemporary = isTemporary;
    }

    public CatalogView getCatalogView() {
        return this.catalogView;
    }

    public ObjectIdentifier getViewIdentifier() {
        return this.viewIdentifier;
    }

    public boolean isIgnoreIfExists() {
        return this.ignoreIfExists;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("originalQuery", this.catalogView.getOriginalQuery());
        params.put("expandedQuery", this.catalogView.getExpandedQuery());
        params.put("identifier", this.viewIdentifier);
        params.put("ignoreIfExists", this.ignoreIfExists);
        params.put("isTemporary", this.isTemporary);
        return OperationUtils.formatWithChildren("CREATE VIEW", params, Collections.emptyList(), Operation::asSummaryString);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        if (this.isTemporary) {
            ctx.getCatalogManager().createTemporaryTable(this.catalogView, this.viewIdentifier, this.ignoreIfExists);
        } else {
            ctx.getCatalogManager().createTable(this.catalogView, this.viewIdentifier, this.ignoreIfExists);
        }
        return TableResultImpl.TABLE_RESULT_OK;
    }
}

