/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.operations.utils.OperationExpressionsUtils;

@Internal
public class JoinQueryOperation
implements QueryOperation {
    private static final String INPUT_1_ALIAS = "$$T1_JOIN";
    private static final String INPUT_2_ALIAS = "$$T2_JOIN";
    private final QueryOperation left;
    private final QueryOperation right;
    private final JoinType joinType;
    private final ResolvedExpression condition;
    private final boolean correlated;
    private final ResolvedSchema resolvedSchema;

    public JoinQueryOperation(QueryOperation left, QueryOperation right, JoinType joinType, ResolvedExpression condition, boolean correlated) {
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.condition = condition;
        this.correlated = correlated;
        this.resolvedSchema = this.calculateResultingSchema(left, right);
    }

    private ResolvedSchema calculateResultingSchema(QueryOperation left, QueryOperation right) {
        ResolvedSchema leftSchema = left.getResolvedSchema();
        ResolvedSchema rightSchema = right.getResolvedSchema();
        return ResolvedSchema.physical(Stream.concat(leftSchema.getColumnNames().stream(), rightSchema.getColumnNames().stream()).collect(Collectors.toList()), Stream.concat(leftSchema.getColumnDataTypes().stream(), rightSchema.getColumnDataTypes().stream()).collect(Collectors.toList()));
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public ResolvedExpression getCondition() {
        return this.condition;
    }

    public boolean isCorrelated() {
        return this.correlated;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("joinType", (Object)this.joinType);
        args.put("condition", this.condition);
        args.put("correlated", this.correlated);
        return OperationUtils.formatWithChildren("Join", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public String asSerializableString(SqlFactory sqlFactory) {
        HashMap<Integer, String> inputAliases = new HashMap<Integer, String>();
        inputAliases.put(0, INPUT_1_ALIAS);
        inputAliases.put(1, this.correlated ? "$$T_LAT" : INPUT_2_ALIAS);
        return String.format("SELECT %s FROM (%s\n) %s %s JOIN %s ON %s", this.getSelectList(), OperationUtils.indent(this.left.asSerializableString(sqlFactory)), INPUT_1_ALIAS, this.joinType.toString().replaceAll("_", " "), this.rightToSerializable(sqlFactory), OperationExpressionsUtils.scopeReferencesWithAlias(inputAliases, this.condition).asSerializableString(sqlFactory));
    }

    private String getSelectList() {
        String leftColumns = OperationUtils.formatSelectColumns(this.left.getResolvedSchema(), INPUT_1_ALIAS);
        String rightColumns = OperationUtils.formatSelectColumns(this.right.getResolvedSchema(), this.correlated ? "$$T_LAT" : INPUT_2_ALIAS);
        return leftColumns + ", " + rightColumns;
    }

    private String rightToSerializable(SqlFactory sqlFactory) {
        StringBuilder s = new StringBuilder();
        if (!this.correlated) {
            s.append("(");
        }
        s.append(OperationUtils.indent(this.right.asSerializableString(sqlFactory)));
        if (!this.correlated) {
            s.append("\n)");
            s.append(" ");
            s.append(INPUT_2_ALIAS);
        }
        return s.toString();
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Arrays.asList(this.left, this.right);
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Internal
    public static enum JoinType {
        INNER,
        LEFT_OUTER,
        RIGHT_OUTER,
        FULL_OUTER;

    }
}

