/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sequencedmultisetstate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.sequencedmultisetstate.SequencedMultiSetState;
import org.apache.flink.table.runtime.sequencedmultisetstate.SequencedMultiSetStateContext;
import org.apache.flink.table.runtime.sequencedmultisetstate.TimeSelector;
import org.apache.flink.types.RowKind;

class ValueStateMultiSetState
implements SequencedMultiSetState<RowData> {
    private final ValueState<List<Tuple2<RowData, Long>>> valuesState;
    private final RecordEqualiser keyEqualiser;
    private final Function<RowData, RowData> keyExtractor;
    private final TimeSelector timeSelector;
    private List<Tuple2<RowData, Long>> cache;

    ValueStateMultiSetState(ValueState<List<Tuple2<RowData, Long>>> valuesState, RecordEqualiser keyEqualiser, Function<RowData, RowData> keyExtractor, TimeSelector timeSelector) {
        this.valuesState = valuesState;
        this.keyEqualiser = keyEqualiser;
        this.keyExtractor = keyExtractor;
        this.timeSelector = timeSelector;
    }

    public static ValueStateMultiSetState create(SequencedMultiSetStateContext p, RuntimeContext ctx) {
        return new ValueStateMultiSetState((ValueState<List<Tuple2<RowData, Long>>>)ctx.getState(new ValueStateDescriptor("list", (TypeSerializer)new ListSerializer((TypeSerializer)new TupleSerializer(Tuple2.class, new TypeSerializer[]{p.recordSerializer, LongSerializer.INSTANCE})))), (RecordEqualiser)p.generatedKeyEqualiser.newInstance(ctx.getUserCodeClassLoader()), p.keyExtractor, p.config.getTimeSelector());
    }

    @Override
    public SequencedMultiSetState.StateChangeInfo<RowData> add(RowData row, long ts) throws Exception {
        ValueStateMultiSetState.normalizeRowKind(row);
        Tuple2 toAdd = Tuple2.of((Object)row, (Object)this.timeSelector.getTimestamp(ts));
        RowData key = this.asKey(row);
        List<Tuple2<RowData, Long>> list = this.maybeReadState();
        long oldSize = list.size();
        int idx = Integer.MIN_VALUE;
        int i = 0;
        for (Tuple2<RowData, Long> t : list) {
            if (this.keyEqualiser.equals(this.asKey((RowData)t.f0), key)) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx < 0) {
            list.add((Tuple2<RowData, Long>)toAdd);
        } else {
            list.set(idx, (Tuple2<RowData, Long>)toAdd);
        }
        this.valuesState.update(list);
        return SequencedMultiSetState.StateChangeInfo.forAddition(oldSize, list.size());
    }

    @Override
    public SequencedMultiSetState.StateChangeInfo<RowData> append(RowData row, long timestamp) throws Exception {
        ValueStateMultiSetState.normalizeRowKind(row);
        List<Tuple2<RowData, Long>> values = this.maybeReadState();
        long oldSize = values.size();
        values.add((Tuple2<RowData, Long>)Tuple2.of((Object)row, (Object)this.timeSelector.getTimestamp(timestamp)));
        this.valuesState.update(values);
        return SequencedMultiSetState.StateChangeInfo.forAddition(oldSize, values.size());
    }

    @Override
    public Iterator<Tuple2<RowData, Long>> iterator() throws Exception {
        return this.maybeReadState().iterator();
    }

    @Override
    public SequencedMultiSetState.StateChangeInfo<RowData> remove(RowData row) throws Exception {
        RowData removed;
        ValueStateMultiSetState.normalizeRowKind(row);
        RowData key = this.asKey(row);
        List<Tuple2<RowData, Long>> list = this.maybeReadState();
        int oldSize = list.size();
        int dropIdx = Integer.MIN_VALUE;
        RowData last = null;
        int i = 0;
        for (Tuple2<RowData, Long> t : list) {
            if (this.keyEqualiser.equals(key, this.asKey((RowData)t.f0))) {
                dropIdx = i;
                break;
            }
            last = (RowData)t.f0;
            ++i;
        }
        if (dropIdx >= 0) {
            list.remove(dropIdx);
            removed = row;
            this.valuesState.update(list);
        } else {
            removed = null;
        }
        return ValueStateMultiSetState.toRemovalResult(oldSize, list.size(), dropIdx, removed, last);
    }

    @Override
    public void loadCache() throws IOException {
        this.cache = this.readState();
    }

    @Override
    public void clearCache() {
        this.cache = null;
    }

    private List<Tuple2<RowData, Long>> maybeReadState() throws IOException {
        if (this.cache != null) {
            return this.cache;
        }
        return this.readState();
    }

    private List<Tuple2<RowData, Long>> readState() throws IOException {
        ArrayList value = (ArrayList)this.valuesState.value();
        if (value == null) {
            value = new ArrayList();
        }
        return value;
    }

    @Override
    public void clear() {
        this.clearCache();
        this.valuesState.clear();
    }

    @Override
    public boolean isEmpty() throws IOException {
        List list = this.cache == null ? (List)this.valuesState.value() : this.cache;
        return list == null || list.isEmpty();
    }

    private RowData asKey(RowData row) {
        return this.keyExtractor.apply(row);
    }

    private static void normalizeRowKind(RowData row) {
        row.setRowKind(RowKind.INSERT);
    }

    private static SequencedMultiSetState.StateChangeInfo<RowData> toRemovalResult(long oldSize, long newSize, int dropIdx, RowData removed, RowData last) {
        if (dropIdx < 0) {
            return SequencedMultiSetState.StateChangeInfo.forRemovalNotFound(oldSize);
        }
        if (newSize == 0L) {
            return SequencedMultiSetState.StateChangeInfo.forAllRemoved(oldSize, newSize, removed);
        }
        if ((long)dropIdx == oldSize - 1L) {
            return SequencedMultiSetState.StateChangeInfo.forRemovedLastAdded(oldSize, newSize, last);
        }
        return SequencedMultiSetState.StateChangeInfo.forRemovedOther(oldSize, newSize);
    }
}

