/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.asyncwindow.processors;

import java.time.ZoneId;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.aggregate.asyncwindow.buffers.AsyncStateWindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.asyncwindow.processors.AbstractAsyncStateSliceWindowAggProcessor;
import org.apache.flink.table.runtime.operators.window.async.tvf.common.AsyncStateWindowProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceUnsharedAssigner;

public final class AsyncStateSliceUnsharedWindowAggProcessor
extends AbstractAsyncStateSliceWindowAggProcessor {
    private static final long serialVersionUID = 1L;

    public AsyncStateSliceUnsharedWindowAggProcessor(GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler, AsyncStateWindowBuffer.Factory windowBufferFactory, SliceUnsharedAssigner sliceAssigner, TypeSerializer<RowData> accSerializer, int indexOfCountStar, ZoneId shiftTimeZone) {
        super(genAggsHandler, windowBufferFactory, sliceAssigner, accSerializer, indexOfCountStar, shiftTimeZone);
    }

    @Override
    public StateFuture<Void> fireWindow(long timerTimestamp, Long windowEnd) throws Exception {
        return this.windowState.asyncValue(windowEnd).thenAccept(acc -> {
            if (acc == null) {
                acc = this.aggregator.createAccumulators();
            }
            if (this.emptyChecker.apply((RowData)acc).booleanValue()) {
                return;
            }
            this.aggregator.setAccumulators(windowEnd, (RowData)acc);
            RowData aggResult = this.aggregator.getValue(windowEnd);
            this.collect(((AsyncStateWindowProcessor.AsyncStateContext)this.ctx).getAsyncKeyContext().getCurrentKey(), aggResult);
        });
    }

    @Override
    protected StateFuture<Long> sliceStateMergeTarget(long sliceToMerge) throws Exception {
        return StateFutureUtils.completedFuture((Object)sliceToMerge);
    }
}

