/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.StructuredType;

@Internal
public class ObjectUpdateFunction
extends BuiltInScalarFunction {
    private Map<String, Integer> fieldNameToRowPosIndex = new HashMap<String, Integer>();

    public ObjectUpdateFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.OBJECT_UPDATE, context);
        this.fieldNameToRowPosIndex = this.createIndex(context);
    }

    public RowData eval(RowData rowData, Object ... fieldNameAndValuePairs) {
        if (rowData == null) {
            return null;
        }
        GenericRowData updatedRow = (GenericRowData)rowData;
        for (int i = 0; i < fieldNameAndValuePairs.length; i += 2) {
            String fieldName = fieldNameAndValuePairs[i].toString();
            int position = this.fieldNameToRowPosIndex.get(fieldName);
            Object fieldValue = fieldNameAndValuePairs[i + 1];
            updatedRow.setField(position, fieldValue);
        }
        return updatedRow;
    }

    private Map<String, Integer> createIndex(SpecializedFunction.SpecializedContext context) {
        StructuredType structuredType = (StructuredType)((DataType)context.getCallContext().getArgumentDataTypes().get(0)).getLogicalType();
        List attributes = structuredType.getAttributes();
        HashMap<String, Integer> fieldToPosIndex = new HashMap<String, Integer>();
        IntStream.range(0, attributes.size()).forEach(pos -> fieldToPosIndex.put(((StructuredType.StructuredAttribute)attributes.get(pos)).getName(), pos));
        return fieldToPosIndex;
    }
}

