/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.connector.sink;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.runtime.connector.sink.DataStructureConverterWrapper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class SinkRuntimeProviderContext
implements DynamicTableSink.Context {
    private final boolean isBounded;
    @Nullable
    private final int[][] targetColumns;

    public SinkRuntimeProviderContext(boolean isBounded) {
        this(isBounded, null);
    }

    public SinkRuntimeProviderContext(boolean isBounded, @Nullable int[][] targetColumns) {
        this.isBounded = isBounded;
        this.targetColumns = targetColumns;
    }

    public boolean isBounded() {
        return this.isBounded;
    }

    public TypeInformation<?> createTypeInformation(DataType consumedDataType) {
        DataTypeUtils.validateOutputDataType((DataType)consumedDataType);
        return InternalTypeInfo.of(consumedDataType.getLogicalType());
    }

    public TypeInformation<?> createTypeInformation(LogicalType consumedLogicalType) {
        return InternalTypeInfo.of(consumedLogicalType);
    }

    public DynamicTableSink.DataStructureConverter createDataStructureConverter(DataType consumedDataType) {
        DataTypeUtils.validateOutputDataType((DataType)consumedDataType);
        return new DataStructureConverterWrapper(DataStructureConverters.getConverter(consumedDataType));
    }

    @Deprecated(since="2.2")
    public Optional<int[][]> getTargetColumns() {
        return Optional.ofNullable(this.targetColumns);
    }
}

