/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.flink.client.cli.ArtifactFetchOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.cli.CliUtils;
import org.apache.flink.table.client.resource.ClientResourceManager;
import org.apache.flink.table.client.util.ClientClassloaderUtil;
import org.apache.flink.table.client.util.ClientWrapperClassLoader;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.session.SessionEnvironment;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.service.context.DefaultContext;
import org.apache.flink.table.gateway.service.context.SessionContext;
import org.apache.flink.table.gateway.service.operation.OperationExecutor;
import org.apache.flink.table.gateway.service.operation.OperationManager;
import org.apache.flink.table.gateway.service.result.ResultFetcher;
import org.apache.flink.table.gateway.service.session.Session;
import org.apache.flink.table.gateway.service.session.SessionManager;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.resource.ResourceType;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.util.MutableURLClassLoader;
import org.apache.flink.util.Preconditions;

public class SingleSessionManager
implements SessionManager {
    private static final ConfigOption<List<String>> YARN_SHIP_FILES = ConfigOptions.key((String)"yarn.ship-files").stringType().asList().noDefaultValue();
    private final DefaultContext defaultContext;
    private final ExecutorService operationExecutorService;
    private Session session;

    public SingleSessionManager(DefaultContext defaultContext) {
        this.defaultContext = defaultContext;
        this.operationExecutorService = Executors.newSingleThreadExecutor();
    }

    public void start() {
    }

    public void stop() {
        this.operationExecutorService.shutdown();
    }

    public Session getSession(SessionHandle sessionHandle) throws SqlGatewayException {
        Preconditions.checkArgument((this.session != null && sessionHandle.equals((Object)this.session.getSessionHandle()) ? 1 : 0) != 0, (Object)"The specified session doesn't exists");
        return this.session;
    }

    public Session openSession(SessionEnvironment environment) throws SqlGatewayException {
        if (this.session != null) {
            throw new SqlClientException(String.format("The %s can only maintain one session at the same time. Please close the current session before opening a new session.", SingleSessionManager.class.getName()));
        }
        SessionHandle sessionHandle = SessionHandle.create();
        this.session = new Session((SessionContext)EmbeddedSessionContext.create(this.defaultContext, sessionHandle, environment, this.operationExecutorService));
        this.session.open();
        return this.session;
    }

    public void closeSession(SessionHandle sessionHandle) throws SqlGatewayException {
        Preconditions.checkArgument((this.session != null && sessionHandle.equals((Object)this.session.getSessionHandle()) ? 1 : 0) != 0, (Object)"The specified session doesn't exist.");
        this.session.close();
        this.session = null;
    }

    private static class EmbeddedOperationExecutor
    extends OperationExecutor {
        public EmbeddedOperationExecutor(SessionContext context, Configuration executionConfig) {
            super(context, executionConfig);
        }

        protected ResultFetcher callRemoveJar(OperationHandle operationHandle, String jarPath) {
            URL jarURL = ((ClientResourceManager)this.sessionContext.getSessionState().resourceManager).unregisterJarResource(jarPath);
            if (jarURL != null) {
                ((ClientWrapperClassLoader)((Object)this.sessionContext.getSessionState().resourceManager.getUserClassLoader())).removeURL(jarURL);
            }
            return ResultFetcher.fromTableResult((OperationHandle)operationHandle, (TableResultInternal)TableResultInternal.TABLE_RESULT_OK, (boolean)false);
        }
    }

    private static class EmbeddedSessionContext
    extends SessionContext {
        private EmbeddedSessionContext(DefaultContext defaultContext, SessionHandle sessionId, EndpointVersion endpointVersion, Configuration sessionConf, URLClassLoader classLoader, SessionContext.SessionState sessionState, OperationManager operationManager) {
            super(defaultContext, sessionId, endpointVersion, sessionConf, classLoader, sessionState, operationManager);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static EmbeddedSessionContext create(DefaultContext defaultContext, SessionHandle sessionId, SessionEnvironment environment, ExecutorService operationExecutorService) {
            List dependencies;
            Configuration configuration = EmbeddedSessionContext.initializeConfiguration((DefaultContext)defaultContext, (SessionEnvironment)environment, (SessionHandle)sessionId);
            if (CliUtils.isApplicationMode((ReadableConfig)configuration)) {
                dependencies = Collections.emptyList();
                if (!defaultContext.getDependencies().isEmpty()) {
                    String target = configuration.getOptional(DeploymentOptions.TARGET).orElse("");
                    if (target.equals("yarn-application")) {
                        configuration.set(YARN_SHIP_FILES, defaultContext.getDependencies().stream().map(URI::toString).collect(Collectors.toList()));
                    } else {
                        if (!target.equals("kubernetes-application")) throw new SqlGatewayException("Unknown deployment target: " + target);
                        configuration.set(ArtifactFetchOptions.ARTIFACT_LIST, defaultContext.getDependencies().stream().map(URI::toString).collect(Collectors.toList()));
                    }
                }
            } else {
                dependencies = defaultContext.getDependencies();
            }
            ClientWrapperClassLoader userClassLoader = new ClientWrapperClassLoader(ClientClassloaderUtil.buildUserClassLoader(Collections.emptyList(), SessionContext.class.getClassLoader(), new Configuration(configuration)), configuration);
            ClientResourceManager resourceManager = new ClientResourceManager(configuration, (MutableURLClassLoader)userClassLoader);
            try {
                resourceManager.registerJarResources(dependencies.stream().map(uri -> new ResourceUri(ResourceType.JAR, uri.toString())).collect(Collectors.toList()));
                return new EmbeddedSessionContext(defaultContext, sessionId, environment.getSessionEndpointVersion(), configuration, (URLClassLoader)((Object)userClassLoader), EmbeddedSessionContext.initializeSessionState((SessionEnvironment)environment, (Configuration)configuration, (ResourceManager)resourceManager), new OperationManager(operationExecutorService));
            }
            catch (IOException e) {
                throw new SqlGatewayException("Failed to open the session.", (Throwable)e);
            }
        }

        public OperationExecutor createOperationExecutor(Configuration executionConfig) {
            return new EmbeddedOperationExecutor(this, executionConfig);
        }
    }
}

