/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.expressions.TableReferenceExpression;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public class FunctionQueryOperation
implements QueryOperation {
    private static final String INPUT_ALIAS = "$$T_FUNC";
    private final ContextResolvedFunction resolvedFunction;
    private final List<ResolvedExpression> arguments;
    private final ResolvedSchema resolvedSchema;

    public FunctionQueryOperation(ContextResolvedFunction resolvedFunction, List<ResolvedExpression> arguments, ResolvedSchema resolvedSchema) {
        this.resolvedFunction = resolvedFunction;
        this.arguments = arguments;
        this.resolvedSchema = resolvedSchema;
    }

    public ContextResolvedFunction getResolvedFunction() {
        return this.resolvedFunction;
    }

    public List<ResolvedExpression> getArguments() {
        return this.arguments;
    }

    public DataType getOutputDataType() {
        return DataTypeUtils.fromResolvedSchemaPreservingTimeAttributes(this.resolvedSchema);
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("function", this.resolvedFunction);
        args.put("arguments", this.arguments);
        return OperationUtils.formatWithChildren("Function", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public String asSerializableString(SqlFactory sqlFactory) {
        return String.format("SELECT %s FROM TABLE(%s\n) %s", OperationUtils.formatSelectColumns(this.getResolvedSchema(), INPUT_ALIAS), OperationUtils.indent(this.resolvedFunction.toCallExpression(this.arguments, this.resolvedSchema.toPhysicalRowDataType()).asSerializableString(sqlFactory)), INPUT_ALIAS);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return this.arguments.stream().filter(TableReferenceExpression.class::isInstance).map(TableReferenceExpression.class::cast).map(TableReferenceExpression::getQueryOperation).collect(Collectors.toList());
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

