/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public class IntervalFreshness {
    private final String interval;
    private final TimeUnit timeUnit;

    private IntervalFreshness(String interval, TimeUnit timeUnit) {
        this.interval = interval;
        this.timeUnit = timeUnit;
    }

    public static IntervalFreshness of(String interval, TimeUnit timeUnit) {
        return new IntervalFreshness(interval, timeUnit);
    }

    public static IntervalFreshness ofSecond(String interval) {
        return new IntervalFreshness(interval, TimeUnit.SECOND);
    }

    public static IntervalFreshness ofMinute(String interval) {
        return new IntervalFreshness(interval, TimeUnit.MINUTE);
    }

    public static IntervalFreshness ofHour(String interval) {
        return new IntervalFreshness(interval, TimeUnit.HOUR);
    }

    public static IntervalFreshness ofDay(String interval) {
        return new IntervalFreshness(interval, TimeUnit.DAY);
    }

    public String getInterval() {
        return this.interval;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalFreshness that = (IntervalFreshness)o;
        return Objects.equals(this.interval, that.interval) && this.timeUnit == that.timeUnit;
    }

    public String toString() {
        return "INTERVAL '" + this.interval + "' " + String.valueOf((Object)this.timeUnit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.timeUnit});
    }

    @PublicEvolving
    public static enum TimeUnit {
        SECOND,
        MINUTE,
        HOUR,
        DAY;

    }
}

