/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.asyncprocessing;

import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.stream.asyncprocessing.AbstractAsyncStateStreamingJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.asyncprocessing.state.JoinRecordAsyncStateView;
import org.apache.flink.table.runtime.operators.join.stream.asyncprocessing.state.JoinRecordAsyncStateViews;
import org.apache.flink.table.runtime.operators.join.stream.asyncprocessing.state.OuterJoinRecordAsyncStateView;
import org.apache.flink.table.runtime.operators.join.stream.asyncprocessing.state.OuterJoinRecordAsyncStateViews;
import org.apache.flink.table.runtime.operators.join.stream.utils.AssociatedRecords;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinHelper;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.types.RowKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncStateStreamingJoinOperator
extends AbstractAsyncStateStreamingJoinOperator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AsyncStateStreamingJoinOperator.class);
    private final boolean leftIsOuter;
    private final boolean rightIsOuter;
    private transient JoinedRowData outRow;
    private transient RowData leftNullRow;
    private transient RowData rightNullRow;
    private transient JoinRecordAsyncStateView leftRecordAsyncStateView;
    private transient JoinRecordAsyncStateView rightRecordAsyncStateView;
    private transient AsyncStateJoinHelper joinHelper;

    public AsyncStateStreamingJoinOperator(InternalTypeInfo<RowData> leftType, InternalTypeInfo<RowData> rightType, GeneratedJoinCondition generatedJoinCondition, JoinInputSideSpec leftInputSideSpec, JoinInputSideSpec rightInputSideSpec, boolean leftIsOuter, boolean rightIsOuter, boolean[] filterNullKeys, long leftStateRetentionTime, long rightStateRetentionTime) {
        super(leftType, rightType, generatedJoinCondition, leftInputSideSpec, rightInputSideSpec, filterNullKeys, leftStateRetentionTime, rightStateRetentionTime);
        this.leftIsOuter = leftIsOuter;
        this.rightIsOuter = rightIsOuter;
    }

    @Override
    public void open() throws Exception {
        super.open();
        LOG.info("Join is using async state");
        this.outRow = new JoinedRowData();
        this.leftNullRow = new GenericRowData(this.leftType.toRowSize());
        this.rightNullRow = new GenericRowData(this.rightType.toRowSize());
        this.leftRecordAsyncStateView = this.leftIsOuter ? OuterJoinRecordAsyncStateViews.create(this.getRuntimeContext(), "left-records", this.leftInputSideSpec, this.leftType, this.leftStateRetentionTime) : JoinRecordAsyncStateViews.create(this.getRuntimeContext(), "left-records", this.leftInputSideSpec, this.leftType, this.leftStateRetentionTime);
        this.rightRecordAsyncStateView = this.rightIsOuter ? OuterJoinRecordAsyncStateViews.create(this.getRuntimeContext(), "right-records", this.rightInputSideSpec, this.rightType, this.rightStateRetentionTime) : JoinRecordAsyncStateViews.create(this.getRuntimeContext(), "right-records", this.rightInputSideSpec, this.rightType, this.rightStateRetentionTime);
        this.joinHelper = new AsyncStateJoinHelper();
    }

    public void processElement1(StreamRecord<RowData> element) throws Exception {
        this.doProcessElement((RowData)element.getValue(), this.leftRecordAsyncStateView, this.rightRecordAsyncStateView, true);
    }

    public void processElement2(StreamRecord<RowData> element) throws Exception {
        this.doProcessElement((RowData)element.getValue(), this.rightRecordAsyncStateView, this.leftRecordAsyncStateView, false);
    }

    private void doProcessElement(RowData input, JoinRecordAsyncStateView inputSideAsyncStateView, JoinRecordAsyncStateView otherSideAsyncStateView, boolean inputIsLeft) throws Exception {
        RowKind originalRowKind = input.getRowKind();
        input.setRowKind(RowKind.INSERT);
        StateFuture<AssociatedRecords> associatedRecordsFuture = AssociatedRecords.fromAsyncStateView(input, inputIsLeft, otherSideAsyncStateView, this.joinCondition);
        input.setRowKind(originalRowKind);
        associatedRecordsFuture.thenAccept(associatedRecords -> this.joinHelper.processJoin(input, inputSideAsyncStateView, otherSideAsyncStateView, inputIsLeft, (AssociatedRecords)associatedRecords, false));
    }

    private class AsyncStateJoinHelper
    extends JoinHelper<JoinRecordAsyncStateView, OuterJoinRecordAsyncStateView> {
        public AsyncStateJoinHelper() {
            super(AsyncStateStreamingJoinOperator.this.leftIsOuter, AsyncStateStreamingJoinOperator.this.rightIsOuter, AsyncStateStreamingJoinOperator.this.outRow, AsyncStateStreamingJoinOperator.this.leftNullRow, AsyncStateStreamingJoinOperator.this.rightNullRow, (TimestampedCollector<RowData>)AsyncStateStreamingJoinOperator.this.collector);
        }

        @Override
        public void addRecord(JoinRecordAsyncStateView stateView, RowData record) throws Exception {
            stateView.addRecord(record);
        }

        @Override
        public void retractRecord(JoinRecordAsyncStateView stateView, RowData record) throws Exception {
            stateView.retractRecord(record);
        }

        @Override
        public void addRecordInOuterSide(OuterJoinRecordAsyncStateView stateView, RowData record, int numOfAssociations) throws Exception {
            stateView.addRecord(record, numOfAssociations);
        }

        @Override
        public void updateNumOfAssociationsInOuterSide(OuterJoinRecordAsyncStateView outerJoinRecordAsyncStateView, RowData record, int numOfAssociations) throws Exception {
            outerJoinRecordAsyncStateView.updateNumOfAssociations(record, numOfAssociations);
        }
    }
}

