/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table.lookup.fullcache.inputformat;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.keyselector.GenericRowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.types.RowKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputSplitCacheLoadTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(InputSplitCacheLoadTask.class);
    private final ConcurrentHashMap<RowData, Collection<RowData>> cache;
    private final GenericRowDataKeySelector keySelector;
    private final RowDataSerializer cacheEntriesSerializer;
    private final InputFormat<RowData, InputSplit> inputFormat;
    private final InputSplit inputSplit;

    public InputSplitCacheLoadTask(ConcurrentHashMap<RowData, Collection<RowData>> cache, GenericRowDataKeySelector keySelector, RowDataSerializer cacheEntriesSerializer, InputFormat<RowData, InputSplit> inputFormat, InputSplit inputSplit) {
        this.cache = cache;
        this.keySelector = keySelector;
        this.inputFormat = inputFormat;
        this.cacheEntriesSerializer = cacheEntriesSerializer;
        this.inputSplit = inputSplit;
        keySelector.open();
    }

    @Override
    public void run() {
        try {
            if (this.inputFormat instanceof RichInputFormat) {
                ((RichInputFormat)this.inputFormat).openInputFormat();
            }
            this.inputFormat.open(this.inputSplit);
            BinaryRowData nextElement = new BinaryRowData(this.cacheEntriesSerializer.getArity());
            while (!this.inputFormat.reachedEnd() && !Thread.currentThread().isInterrupted() && (nextElement = (RowData)this.inputFormat.nextRecord((Object)nextElement)) != null) {
                if (nextElement.getRowKind() != RowKind.INSERT) {
                    throw new IllegalStateException("InputFormat must provide only INSERT records in lookup 'FULL' cache. Received record " + String.valueOf(nextElement));
                }
                RowData record = this.cacheEntriesSerializer.copy((RowData)nextElement);
                RowData key = this.keySelector.getKey(record);
                if (!InputSplitCacheLoadTask.hasNoNulls(key)) continue;
                Collection resultRows = this.cache.computeIfAbsent(key, k -> new ConcurrentLinkedQueue());
                resultRows.add(record);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load data into the lookup 'FULL' cache from InputSplit " + String.valueOf(this.inputSplit), e);
        }
        finally {
            try {
                this.inputFormat.close();
                if (this.inputFormat instanceof RichInputFormat) {
                    ((RichInputFormat)this.inputFormat).closeInputFormat();
                }
            }
            catch (IOException e) {
                LOG.error("Failed to close InputFormat.", (Throwable)e);
            }
        }
    }

    private static boolean hasNoNulls(RowData keys) {
        for (int i = 0; i < keys.getArity(); ++i) {
            if (!keys.isNullAt(i)) continue;
            return false;
        }
        return true;
    }
}

