/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table.lookup.fullcache;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.ThreadSafeSimpleCounter;
import org.apache.flink.metrics.groups.CacheMetricGroup;
import org.apache.flink.shaded.guava33.com.google.common.base.Joiner;
import org.apache.flink.table.data.RowData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheLoader
implements AutoCloseable,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(CacheLoader.class);
    protected static final long TIMEOUT_AFTER_INTERRUPT_MS = 10000L;
    protected volatile transient ConcurrentHashMap<RowData, Collection<RowData>> cache;
    private final ReentrantLock reloadLock = new ReentrantLock();
    private transient CountDownLatch firstLoadLatch;
    private transient ExecutorService reloadExecutor;
    private transient Counter loadCounter;
    private transient Counter loadFailuresCounter;
    private volatile long latestLoadTimeMs = -1L;
    protected volatile boolean isStopped;

    protected abstract boolean updateCache() throws Exception;

    public void open(Configuration parameters, ClassLoader userCodeClassLoader) throws Exception {
        this.firstLoadLatch = new CountDownLatch(1);
        this.reloadExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("full-cache-loader-executor");
            thread.setContextClassLoader(userCodeClassLoader);
            return thread;
        });
    }

    public void initializeMetrics(CacheMetricGroup cacheMetricGroup) {
        if (this.loadCounter == null) {
            this.loadCounter = new ThreadSafeSimpleCounter();
        }
        if (this.loadFailuresCounter == null) {
            this.loadFailuresCounter = new ThreadSafeSimpleCounter();
        }
        if (this.cache == null) {
            this.cache = new ConcurrentHashMap();
        }
        cacheMetricGroup.loadCounter(this.loadCounter);
        cacheMetricGroup.numLoadFailuresCounter(this.loadFailuresCounter);
        cacheMetricGroup.numCachedRecordsGauge(() -> this.cache.size());
        cacheMetricGroup.latestLoadTimeGauge(() -> this.latestLoadTimeMs);
    }

    public ConcurrentHashMap<RowData, Collection<RowData>> getCache() {
        return this.cache;
    }

    public void awaitFirstLoad() throws InterruptedException {
        this.firstLoadLatch.await();
    }

    public CompletableFuture<Void> reloadAsync() {
        return CompletableFuture.runAsync(this::reload, this.reloadExecutor);
    }

    private void reload() {
        if (this.isStopped) {
            return;
        }
        this.reloadLock.lock();
        try {
            LOG.info("Lookup 'FULL' cache loading triggered.");
            long start = System.currentTimeMillis();
            boolean success = this.updateCache();
            this.latestLoadTimeMs = System.currentTimeMillis() - start;
            if (success) {
                this.loadCounter.inc();
                LOG.info("Lookup 'FULL' cache loading finished. Time elapsed - {} ms. Number of records - {}.", (Object)this.latestLoadTimeMs, (Object)this.cache.size());
            } else {
                LOG.info("Active lookup 'FULL' cache reload has been interrupted.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache content: \n{\n\t{}\n}", (Object)Joiner.on((String)",\n\t").withKeyValueSeparator(" = ").join(this.cache));
            }
        }
        catch (Exception e) {
            this.loadFailuresCounter.inc();
            this.isStopped = true;
            throw new RuntimeException("Failed to reload lookup 'FULL' cache.", e);
        }
        finally {
            this.reloadLock.unlock();
            this.firstLoadLatch.countDown();
        }
    }

    @Override
    public void close() throws Exception {
        this.isStopped = true;
        if (this.reloadExecutor != null) {
            this.reloadExecutor.shutdownNow();
            if (!this.reloadExecutor.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Lookup 'FULL' cache reload thread was not terminated after closing in timeout of 10000 ms.");
            }
        }
        if (this.cache != null) {
            this.cache.clear();
        }
    }
}

