/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.state.forst;

import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.IncrementalRemoteKeyedStateHandle;

/**
 * This class represents a transfer specification for the content of one {@link
 * IncrementalRemoteKeyedStateHandle} to a target {@link Path}.
 */
public class StateHandleTransferSpec {
    /** The state handle to transfer. */
    private final IncrementalRemoteKeyedStateHandle stateHandle;

    /** The path to which the content of the state handle shall be transferred. */
    private final Path transferDestination;

    public StateHandleTransferSpec(
            IncrementalRemoteKeyedStateHandle stateHandle, Path transferDestination) {
        this.stateHandle = stateHandle;
        this.transferDestination = transferDestination;
    }

    public IncrementalRemoteKeyedStateHandle getStateHandle() {
        return stateHandle;
    }

    public Path getTransferDestination() {
        return transferDestination;
    }

    @Override
    public String toString() {
        return "StateHandleTransferSpec(transferDestination = ["
                + transferDestination
                + "] stateHandle = ["
                + stateHandle
                + "])";
    }
}
