/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.event.ProgressInputStream;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.event.ProgressPublisher;
import com.aliyun.oss.model.WebServiceRequest;
import java.io.InputStream;
import java.util.Map;

public class ResponseProgressHandler
implements ResponseHandler {
    private final WebServiceRequest originalRequest;

    public ResponseProgressHandler(WebServiceRequest originalRequest) {
        this.originalRequest = originalRequest;
    }

    @Override
    public void handle(ResponseMessage response) throws OSSException, ClientException {
        InputStream content;
        ProgressListener listener = this.originalRequest.getProgressListener();
        Map<String, String> headers = response.getHeaders();
        String s2 = headers.get("Content-Length");
        if (s2 != null) {
            try {
                long contentLength = Long.parseLong(s2);
                ProgressPublisher.publishResponseContentLength(listener, contentLength);
            }
            catch (NumberFormatException e) {
                LogUtils.logException("Cannot parse the Content-Length header of the response: ", e);
            }
        }
        if ((content = response.getContent()) != null && listener != ProgressListener.NOOP) {
            InputStream progressInputStream = ProgressInputStream.inputStreamForResponse(content, this.originalRequest);
            response.setContent(progressInputStream);
        }
    }
}

