/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.ModelChange;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.AlterOperation;

@Internal
public class AlterModelChangeOperation
implements AlterOperation {
    private final ObjectIdentifier modelIdentifier;
    private final List<ModelChange> modelChanges;
    private final CatalogModel catalogModel;
    private final boolean ignoreIfNotExists;

    public ObjectIdentifier getModelIdentifier() {
        return this.modelIdentifier;
    }

    public List<ModelChange> getModelChanges() {
        return this.modelChanges;
    }

    @Nullable
    public CatalogModel getCatalogModel() {
        return this.catalogModel;
    }

    public boolean ignoreIfNotExists() {
        return this.ignoreIfNotExists;
    }

    public AlterModelChangeOperation(ObjectIdentifier modelIdentifier, List<ModelChange> modelChanges, @Nullable CatalogModel catalogModel, boolean ignoreIfNotExists) {
        this.modelIdentifier = modelIdentifier;
        this.modelChanges = modelChanges;
        this.catalogModel = catalogModel;
        this.ignoreIfNotExists = ignoreIfNotExists;
    }

    @Override
    public String asSummaryString() {
        String changes = this.modelChanges.stream().map(AlterModelChangeOperation::toString).collect(Collectors.joining(",\n"));
        return String.format("ALTER MODEL %s%s\n%s", this.ignoreIfNotExists ? "IF EXISTS " : "", this.modelIdentifier.asSummaryString(), changes);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        if (this.getCatalogModel() == null && this.ignoreIfNotExists()) {
            return TableResultImpl.TABLE_RESULT_OK;
        }
        ctx.getCatalogManager().alterModel(this.getCatalogModel(), this.modelChanges, this.getModelIdentifier(), this.ignoreIfNotExists());
        return TableResultImpl.TABLE_RESULT_OK;
    }

    private static String toString(ModelChange modelChange) {
        if (modelChange instanceof ModelChange.SetOption) {
            ModelChange.SetOption setOption = (ModelChange.SetOption)modelChange;
            return String.format("  SET (%s)", OperationUtils.formatParameter(setOption.getKey(), setOption.getValue()));
        }
        if (modelChange instanceof ModelChange.ResetOption) {
            ModelChange.ResetOption resetOption = (ModelChange.ResetOption)modelChange;
            return String.format("  RESET (%s)", resetOption.getKey());
        }
        throw new UnsupportedOperationException(String.format("Unknown model change: %s", modelChange));
    }
}

