/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.listener;

import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.listener.CatalogContext;
import org.apache.flink.table.catalog.listener.CatalogModificationEvent;
import org.apache.flink.table.catalog.listener.DatabaseModificationEvent;

@PublicEvolving
public interface AlterDatabaseEvent
extends DatabaseModificationEvent {
    public CatalogDatabase newDatabase();

    public boolean ignoreIfNotExists();

    public static CatalogModificationEvent createEvent(final CatalogContext context, final String databaseName, final CatalogDatabase newDatabase, final boolean ignoreIfNotExists) {
        return new AlterDatabaseEvent(){

            @Override
            public CatalogDatabase newDatabase() {
                return newDatabase;
            }

            @Override
            public boolean ignoreIfNotExists() {
                return ignoreIfNotExists;
            }

            @Override
            @Nullable
            public CatalogDatabase database() {
                throw new IllegalStateException("There is no database in AlterDatabaseEvent, use database name instead.");
            }

            @Override
            public String databaseName() {
                return databaseName;
            }

            @Override
            public CatalogContext context() {
                return context;
            }
        };
    }
}

