/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.state.api.output.BootstrapStreamTask;
import org.apache.flink.state.api.output.EndOfDataMarker;
import org.apache.flink.state.api.output.TaggedOperatorSubtaskState;
import org.apache.flink.state.api.runtime.SavepointEnvironment;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class BootstrapStreamTaskRunner<IN>
extends AbstractStreamOperator<TaggedOperatorSubtaskState>
implements OneInputStreamOperator<IN, TaggedOperatorSubtaskState>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final StreamConfig streamConfig;
    private final int maxParallelism;
    private transient Thread task;
    private transient BlockingQueue<StreamElement> input;

    public BootstrapStreamTaskRunner(StreamConfig streamConfig, int maxParallelism) {
        this.streamConfig = streamConfig;
        this.maxParallelism = maxParallelism;
    }

    public void open() throws Exception {
        this.input = new ArrayBlockingQueue<StreamElement>(16);
        SavepointEnvironment env = new SavepointEnvironment.Builder((RuntimeContext)this.getRuntimeContext(), this.getExecutionConfig(), this.maxParallelism).setConfiguration(this.streamConfig.getConfiguration()).build();
        this.task = new Thread(() -> {
            BootstrapStreamTask boundedStreamTask;
            try {
                boundedStreamTask = new BootstrapStreamTask(env, this.input, this.output);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to construct bootstrap stream task", e);
            }
            Exception error = null;
            try {
                boundedStreamTask.invoke();
            }
            catch (Exception e) {
                error = e;
            }
            try {
                boundedStreamTask.cleanUp(error);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to cleanup task", e);
            }
        });
        this.task.setName(this.streamConfig.getOperatorName() + "-bootstrap-thread-" + this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask());
        this.task.start();
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        this.input.put((StreamElement)element);
    }

    public void endInput() throws Exception {
        this.input.put(EndOfDataMarker.INSTANCE);
        this.task.join();
    }
}

