/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators;

import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.asyncprocessing.operators.AbstractAsyncStateStreamOperator;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.streaming.api.TimerService;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.Preconditions;

public abstract class AsyncStateTableStreamOperator<OUT>
extends AbstractAsyncStateStreamOperator<OUT> {
    protected long currentWatermark = Long.MIN_VALUE;
    protected transient ContextImpl ctx;

    public void open() throws Exception {
        super.open();
        this.ctx = new ContextImpl(this.getProcessingTimeService());
    }

    public boolean useSplittableTimers() {
        return true;
    }

    public long computeMemorySize() {
        Environment environment = this.getContainingTask().getEnvironment();
        return environment.getMemoryManager().computeMemorySize(this.getOperatorConfig().getManagedMemoryFractionOperatorUseCaseOfSlot(ManagedMemoryUseCase.OPERATOR, environment.getJobConfiguration(), environment.getTaskManagerInfo().getConfiguration(), environment.getUserCodeClassLoader().asClassLoader()));
    }

    public Watermark preProcessWatermark(Watermark mark) throws Exception {
        this.currentWatermark = mark.getTimestamp();
        return super.preProcessWatermark(mark);
    }

    protected class ContextImpl
    implements TimerService {
        protected final ProcessingTimeService timerService;
        public StreamRecord<?> element;

        ContextImpl(ProcessingTimeService timerService) {
            this.timerService = (ProcessingTimeService)Preconditions.checkNotNull((Object)timerService);
        }

        public Long timestamp() {
            Preconditions.checkState((this.element != null ? 1 : 0) != 0);
            if (this.element.hasTimestamp()) {
                return this.element.getTimestamp();
            }
            return null;
        }

        public long currentProcessingTime() {
            return this.timerService.getCurrentProcessingTime();
        }

        public long currentWatermark() {
            return AsyncStateTableStreamOperator.this.currentWatermark;
        }

        public void registerProcessingTimeTimer(long time) {
            throw new UnsupportedOperationException("Setting timers is only supported on keyed streams.");
        }

        public void registerEventTimeTimer(long time) {
            throw new UnsupportedOperationException("Setting timers is only supported on keyed streams.");
        }

        public void deleteProcessingTimeTimer(long time) {
            throw new UnsupportedOperationException("Delete timers is only supported on keyed streams.");
        }

        public void deleteEventTimeTimer(long time) {
            throw new UnsupportedOperationException("Delete timers is only supported on keyed streams.");
        }

        public TimerService timerService() {
            return this;
        }
    }
}

