/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.InvalidTTLException;

public final class TTL {
    public static final long MAX_VALUE = Integer.MAX_VALUE;

    private TTL() {
    }

    static void check(long i) {
        if (i < 0L || i > Integer.MAX_VALUE) {
            throw new InvalidTTLException(i);
        }
    }

    public static long parse(String s2, boolean clamp) {
        if (s2 == null || s2.length() == 0 || !Character.isDigit(s2.charAt(0))) {
            throw new NumberFormatException();
        }
        long value = 0L;
        long ttl = 0L;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            long oldvalue = value;
            if (Character.isDigit(c)) {
                if ((value = value * 10L + (long)Character.getNumericValue(c)) >= oldvalue) continue;
                throw new NumberFormatException();
            }
            switch (Character.toUpperCase(c)) {
                case 'W': {
                    value *= 7L;
                }
                case 'D': {
                    value *= 24L;
                }
                case 'H': {
                    value *= 60L;
                }
                case 'M': {
                    value *= 60L;
                }
                case 'S': {
                    break;
                }
                default: {
                    throw new NumberFormatException();
                }
            }
            value = 0L;
            if ((ttl += value) <= 0xFFFFFFFFL) continue;
            throw new NumberFormatException();
        }
        if (ttl == 0L) {
            ttl = value;
        }
        if (ttl > 0xFFFFFFFFL) {
            throw new NumberFormatException();
        }
        if (ttl > Integer.MAX_VALUE && clamp) {
            ttl = Integer.MAX_VALUE;
        }
        return ttl;
    }

    public static long parseTTL(String s2) {
        return TTL.parse(s2, true);
    }

    public static String format(long ttl) {
        TTL.check(ttl);
        StringBuffer sb = new StringBuffer();
        long secs = ttl % 60L;
        long mins = (ttl /= 60L) % 60L;
        long hours = (ttl /= 60L) % 24L;
        long days = (ttl /= 24L) % 7L;
        long weeks = ttl /= 7L;
        if (weeks > 0L) {
            sb.append(weeks + "W");
        }
        if (days > 0L) {
            sb.append(days + "D");
        }
        if (hours > 0L) {
            sb.append(hours + "H");
        }
        if (mins > 0L) {
            sb.append(mins + "M");
        }
        if (secs > 0L || weeks == 0L && days == 0L && hours == 0L && mins == 0L) {
            sb.append(secs + "S");
        }
        return sb.toString();
    }
}

